/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HBaseMappingDesc
implements Serializable {
    @JsonProperty(value="column_family")
    private HBaseColumnFamilyDesc[] columnFamily;
    private CubeDesc cubeRef;

    public Collection<HBaseColumnDesc> findHBaseColumnByFunction(FunctionDesc function) {
        LinkedList<HBaseColumnDesc> result = new LinkedList<HBaseColumnDesc>();
        HBaseMappingDesc hbaseMapping = this.cubeRef.getHbaseMapping();
        if (hbaseMapping == null || hbaseMapping.getColumnFamily() == null) {
            return result;
        }
        for (HBaseColumnFamilyDesc cf : hbaseMapping.getColumnFamily()) {
            for (HBaseColumnDesc c : cf.getColumns()) {
                for (MeasureDesc m : c.getMeasures()) {
                    if (!m.getFunction().equals(function)) continue;
                    result.add(c);
                }
            }
        }
        return result;
    }

    public CubeDesc getCubeRef() {
        return this.cubeRef;
    }

    public void setCubeRef(CubeDesc cubeRef) {
        this.cubeRef = cubeRef;
    }

    public HBaseColumnFamilyDesc[] getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(HBaseColumnFamilyDesc[] columnFamily) {
        this.columnFamily = columnFamily;
    }

    public void init(CubeDesc cubeDesc) {
        this.cubeRef = cubeDesc;
        for (HBaseColumnFamilyDesc cf : this.columnFamily) {
            cf.setName(cf.getName().toUpperCase(Locale.ROOT));
            for (HBaseColumnDesc c : cf.getColumns()) {
                c.setQualifier(c.getQualifier().toUpperCase(Locale.ROOT));
                StringUtil.toUpperCaseArray(c.getMeasureRefs(), c.getMeasureRefs());
            }
        }
    }

    public void initAsSeparatedColumns(CubeDesc cubeDesc) {
        this.cubeRef = cubeDesc;
        int cfNum = cubeDesc.getMeasures().size();
        this.columnFamily = new HBaseColumnFamilyDesc[cfNum];
        for (int i = 0; i < cfNum; ++i) {
            HBaseColumnFamilyDesc cf = new HBaseColumnFamilyDesc();
            HBaseColumnDesc col = new HBaseColumnDesc();
            String measureRef = cubeDesc.getMeasures().get(i).getName();
            col.setMeasureRefs(new String[]{measureRef});
            col.setQualifier("M");
            cf.setColumns(new HBaseColumnDesc[]{col});
            cf.setName("F" + (i + 1));
            this.columnFamily[i] = cf;
        }
    }

    public String toString() {
        return "HBaseMappingDesc [columnFamily=" + Arrays.toString(this.columnFamily) + "]";
    }
}

