/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup.cache;

import org.apache.kylin.dict.lookup.AbstractLookupRowEncoder;
import org.apache.kylin.metadata.model.TableDesc;

public class RocksDBLookupRowEncoder
extends AbstractLookupRowEncoder<KV> {
    public RocksDBLookupRowEncoder(TableDesc tableDesc, String[] keyColumns) {
        super(tableDesc, keyColumns);
    }

    @Override
    public KV encode(String[] row) {
        String[] keys = this.getKeyData(row);
        String[] values = this.getValueData(row);
        byte[] encodeKey = this.encodeStringsWithLenPfx(keys, false);
        byte[] encodeValue = this.encodeStringsWithLenPfx(values, true);
        return new KV(encodeKey, encodeValue);
    }

    @Override
    public String[] decode(KV kv) {
        String[] result = new String[this.columnsNum];
        this.decodeFromLenPfxBytes(kv.key, this.keyIndexes, result);
        this.decodeFromLenPfxBytes(kv.value, this.valueIndexes, result);
        return result;
    }

    public static class KV {
        private byte[] key;
        private byte[] value;

        public KV(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }
    }
}

