/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTableHFilesBulkLoadJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(LookupTableHFilesBulkLoadJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(OPTION_INPUT_PATH);
        options.addOption(OPTION_TABLE_NAME);
        options.addOption(OPTION_CUBING_JOB_ID);
        options.addOption(OPTION_LOOKUP_SNAPSHOT_ID);
        this.parseOptions(options, args);
        String tableName = this.getOptionValue(OPTION_TABLE_NAME);
        String cubingJobID = this.getOptionValue(OPTION_CUBING_JOB_ID);
        String snapshotID = this.getOptionValue(OPTION_LOOKUP_SNAPSHOT_ID);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager execMgr = ExecutableManager.getInstance((KylinConfig)kylinConfig);
        DefaultChainedExecutable job = (DefaultChainedExecutable)execMgr.getJob(cubingJobID);
        ExtTableSnapshotInfoManager extTableSnapshotInfoManager = ExtTableSnapshotInfoManager.getInstance(kylinConfig);
        ExtTableSnapshotInfo snapshot = extTableSnapshotInfoManager.getSnapshot(tableName, snapshotID);
        long srcTableRowCnt = Long.parseLong(job.findExtraInfoBackward("lookup.ext.snapshot.src.record.cnt." + tableName, "-1"));
        logger.info("update table:{} snapshot row count:{}", (Object)tableName, (Object)srcTableRowCnt);
        snapshot.setRowCnt(srcTableRowCnt);
        snapshot.setLastBuildTime(System.currentTimeMillis());
        extTableSnapshotInfoManager.updateSnapshot(snapshot);
        String hTableName = snapshot.getStorageLocationIdentifier();
        String input = this.getOptionValue(OPTION_INPUT_PATH);
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        FsShell shell = new FsShell(conf);
        int exitCode = -1;
        for (int retryCount = 10; exitCode != 0 && retryCount >= 1; --retryCount) {
            exitCode = shell.run(new String[]{"-chmod", "-R", "777", input});
            Thread.sleep(5000L);
        }
        if (exitCode != 0) {
            logger.error("Failed to change the file permissions: {}", (Object)input);
            throw new IOException("Failed to change the file permissions: " + input);
        }
        String[] newArgs = new String[]{input, hTableName};
        logger.debug("Start to run LoadIncrementalHFiles");
        int ret = MRUtil.runMRJob((Tool)new LoadIncrementalHFiles(conf), (String[])newArgs);
        logger.debug("End to run LoadIncrementalHFiles");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new LookupTableHFilesBulkLoadJob(), (String[])args);
        System.exit(exitCode);
    }
}

