/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.shaded.org.apache.commons.codec.binary.Base64;

public class EncryptUtil {
    private static byte[] key = new byte[]{116, 104, 105, 115, 73, 115, 65, 83, 101, 99, 114, 101, 116, 75, 101, 121};

    private static final Cipher getCipher(int cipherMode) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("AES/CFB/PKCS5Padding");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(KylinConfig.getInstanceFromEnv().getEncryptCipherIvSpec().getBytes("UTF-8"));
        cipher.init(cipherMode, (Key)secretKey, ivSpec);
        return cipher;
    }

    public static String encrypt(String strToEncrypt) {
        if (strToEncrypt == null) {
            return null;
        }
        try {
            Cipher cipher = EncryptUtil.getCipher(1);
            String encryptedString = Base64.encodeBase64String(cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
            return encryptedString;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decrypt(String strToDecrypt) {
        if (strToDecrypt == null) {
            return null;
        }
        try {
            Cipher cipher = EncryptUtil.getCipher(2);
            String decryptedString = new String(cipher.doFinal(Base64.decodeBase64(strToDecrypt)), StandardCharsets.UTF_8);
            return decryptedString;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.kylin.common.util <your_password>");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            EncryptUtil.printUsage();
            System.exit(1);
        }
        String passwordTxt = args[0];
        System.out.println(EncryptUtil.encrypt(passwordTxt));
    }
}

