/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.inmemcubing.AbstractInMemCubeBuilder;
import org.apache.kylin.cube.inmemcubing.CuboidResult;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.inmemcubing.RecordConsumeBlockingQueueController;
import org.apache.kylin.cube.inmemcubing2.CuboidTask;
import org.apache.kylin.cube.inmemcubing2.ICuboidResultListener;
import org.apache.kylin.cube.inmemcubing2.InMemCubeBuilder2;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Stopwatch;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Queues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoggedCubeBuilder2
extends AbstractInMemCubeBuilder {
    private static Logger logger = LoggerFactory.getLogger(DoggedCubeBuilder2.class);

    public DoggedCubeBuilder2(CuboidScheduler cuboidScheduler, IJoinedFlatTableDesc flatDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        super(cuboidScheduler, flatDesc, dictionaryMap);
    }

    @Override
    public <T> void build(BlockingQueue<T> input, InputConverterUnit<T> inputConverterUnit, ICuboidWriter output) throws IOException {
        new BuildOnce().build(input, inputConverterUnit, output);
    }

    private static class ResultMergeSlot
    implements Comparable<ResultMergeSlot> {
        CuboidResult splitResult;
        IGTScanner scanner;
        Iterator<GTRecord> recordIterator;
        long currentCuboidId;
        GTRecord currentRecord;

        public ResultMergeSlot(CuboidResult splitResult) {
            this.splitResult = splitResult;
        }

        public boolean fetchNext() throws IOException {
            if (this.recordIterator == null) {
                this.currentCuboidId = this.splitResult.cuboidId;
                this.scanner = this.splitResult.table.scan(new GTScanRequestBuilder().setInfo(this.splitResult.table.getInfo()).setRanges(null).setDimensions(null).setFilterPushDown(null).createGTScanRequest());
                this.recordIterator = this.scanner.iterator();
            }
            if (this.recordIterator.hasNext()) {
                this.currentRecord = this.recordIterator.next();
                return true;
            }
            this.scanner.close();
            this.recordIterator = null;
            return false;
        }

        @Override
        public int compareTo(ResultMergeSlot o) {
            long cuboidComp = this.currentCuboidId - o.currentCuboidId;
            if (cuboidComp != 0L) {
                return cuboidComp < 0L ? -1 : 1;
            }
            ImmutableBitSet pk = this.currentRecord.getInfo().getPrimaryKey();
            for (int i = 0; i < pk.trueBitCount(); ++i) {
                int c = pk.trueBitAt(i);
                int comp = this.currentRecord.get(c).compareTo(o.currentRecord.get(c));
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }

        public boolean isSameKey(ResultMergeSlot o) {
            if (o == null) {
                return false;
            }
            return this.compareTo(o) == 0;
        }
    }

    private class SplitMerger {
        MeasureAggregators reuseAggrs;
        Object[] reuseMetricsArray;
        ByteArray reuseMetricsSpace;
        long lastCuboidColumnCount;
        ImmutableBitSet lastMetricsColumns;

        SplitMerger() {
            this.reuseAggrs = new MeasureAggregators(DoggedCubeBuilder2.this.cubeDesc.getMeasures());
            this.reuseMetricsArray = new Object[DoggedCubeBuilder2.this.cubeDesc.getMeasures().size()];
        }

        public void mergeAndOutput(List<CuboidResult> splitResultList, ICuboidWriter output) throws IOException {
            if (splitResultList.size() == 1) {
                CuboidResult cuboidResult = splitResultList.get(0);
                DoggedCubeBuilder2.this.outputCuboid(cuboidResult.cuboidId, cuboidResult.table, output);
                return;
            }
            LinkedList<ResultMergeSlot> open = Lists.newLinkedList();
            for (CuboidResult splitResult : splitResultList) {
                open.add(new ResultMergeSlot(splitResult));
            }
            PriorityQueue<ResultMergeSlot> heap = new PriorityQueue<ResultMergeSlot>();
            while (true) {
                if (!open.isEmpty()) {
                    ResultMergeSlot slot = (ResultMergeSlot)open.removeFirst();
                    if (!slot.fetchNext()) continue;
                    heap.add(slot);
                    continue;
                }
                ResultMergeSlot smallest = (ResultMergeSlot)heap.poll();
                if (smallest == null) break;
                open.add(smallest);
                if (smallest.isSameKey((ResultMergeSlot)heap.peek())) {
                    Object[] metrics = this.getMetricsValues(smallest.currentRecord);
                    this.reuseAggrs.reset();
                    this.reuseAggrs.aggregate(metrics);
                    do {
                        ResultMergeSlot slot = (ResultMergeSlot)heap.poll();
                        open.add(slot);
                        metrics = this.getMetricsValues(slot.currentRecord);
                        this.reuseAggrs.aggregate(metrics);
                    } while (smallest.isSameKey((ResultMergeSlot)heap.peek()));
                    this.reuseAggrs.collectStates(metrics);
                    this.setMetricsValues(smallest.currentRecord, metrics);
                }
                output.write(smallest.currentCuboidId, smallest.currentRecord);
            }
        }

        private void setMetricsValues(GTRecord record, Object[] metricsValues) {
            ImmutableBitSet metrics = this.getMetricsColumns(record);
            if (this.reuseMetricsSpace == null) {
                this.reuseMetricsSpace = new ByteArray(record.getInfo().getMaxColumnLength(metrics));
            }
            record.setValues(metrics, this.reuseMetricsSpace, metricsValues);
        }

        private Object[] getMetricsValues(GTRecord record) {
            ImmutableBitSet metrics = this.getMetricsColumns(record);
            return record.getValues(metrics, this.reuseMetricsArray);
        }

        private ImmutableBitSet getMetricsColumns(GTRecord record) {
            if (this.lastCuboidColumnCount == (long)record.getInfo().getColumnCount()) {
                return this.lastMetricsColumns;
            }
            int to = record.getInfo().getColumnCount();
            int from = to - this.reuseMetricsArray.length;
            this.lastCuboidColumnCount = record.getInfo().getColumnCount();
            this.lastMetricsColumns = new ImmutableBitSet(from, to);
            return this.lastMetricsColumns;
        }
    }

    private class CuboidResultWatcher
    implements ICuboidResultListener {
        final BlockingQueue<CuboidResult> outputQueue;
        final Map<Long, List<CuboidResult>> pendingQueue = Maps.newHashMap();
        final List<InMemCubeBuilder2> builderList;
        final ICuboidWriter output;

        public CuboidResultWatcher(List<InMemCubeBuilder2> builderList, ICuboidWriter output) {
            this.outputQueue = Queues.newLinkedBlockingQueue();
            this.builderList = builderList;
            this.output = output;
        }

        public void start() throws IOException {
            SplitMerger merger = new SplitMerger();
            while (true) {
                if (!this.outputQueue.isEmpty()) {
                    ArrayList<Object> splitResultReturned = Lists.newArrayList();
                    this.outputQueue.drainTo(splitResultReturned);
                    for (Object splitResult : splitResultReturned) {
                        if (this.builderList.size() == 1) {
                            merger.mergeAndOutput(Lists.newArrayList(splitResult), this.output);
                            continue;
                        }
                        List<CuboidResult> cuboidResultList = this.pendingQueue.get(((CuboidResult)splitResult).cuboidId);
                        if (cuboidResultList == null) {
                            cuboidResultList = Lists.newArrayListWithExpectedSize(this.builderList.size());
                            cuboidResultList.add((CuboidResult)splitResult);
                            this.pendingQueue.put(((CuboidResult)splitResult).cuboidId, cuboidResultList);
                        } else {
                            cuboidResultList.add((CuboidResult)splitResult);
                        }
                        if (cuboidResultList.size() != this.builderList.size()) continue;
                        merger.mergeAndOutput(cuboidResultList, this.output);
                        this.pendingQueue.remove(((CuboidResult)splitResult).cuboidId);
                    }
                }
                boolean jobFinished = this.isAllBuildFinished();
                if (this.outputQueue.isEmpty() && !jobFinished) {
                    Object splitResult;
                    boolean ifWait = true;
                    splitResult = this.builderList.iterator();
                    while (splitResult.hasNext()) {
                        InMemCubeBuilder2 builder = (InMemCubeBuilder2)splitResult.next();
                        Queue<CuboidTask> queue = builder.getCompletedTaskQueue();
                        while (queue.size() > 0) {
                            CuboidTask childTask = queue.poll();
                            if (childTask.isCompletedAbnormally()) {
                                throw new RuntimeException(childTask.getException());
                            }
                            ifWait = false;
                        }
                    }
                    if (!ifWait) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.outputQueue.isEmpty() && this.pendingQueue.isEmpty() && jobFinished) break;
            }
        }

        private boolean isAllBuildFinished() {
            for (InMemCubeBuilder2 split : this.builderList) {
                if (split.isAllCuboidDone()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void finish(CuboidResult result) {
            Stopwatch stopwatch = Stopwatch.createUnstarted().start();
            int nRetries = 0;
            while (!this.outputQueue.offer(result)) {
                ++nRetries;
                long sleepTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (sleepTime > 3600000L) {
                    stopwatch.stop();
                    throw new RuntimeException("OutputQueue Full. Cannot offer to the output queue after waiting for one hour!!! Current queue size: " + this.outputQueue.size());
                }
                logger.warn("OutputQueue Full. Queue size: " + this.outputQueue.size() + ". Total sleep time : " + sleepTime + ", and retry count : " + nRetries);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            stopwatch.stop();
        }
    }

    private class BaseCuboidTask<T>
    extends RecursiveTask<CuboidResult> {
        private static final long serialVersionUID = -5408592502260876799L;
        private final int splitSeq;
        private final ICuboidResultListener resultListener;
        private RecordConsumeBlockingQueueController<T> inputController;
        private InMemCubeBuilder2 builder;
        private volatile BaseCuboidTask<T> next;

        public BaseCuboidTask(RecordConsumeBlockingQueueController<T> inputController, int splitSeq, ICuboidResultListener resultListener) {
            this.inputController = inputController;
            this.splitSeq = splitSeq;
            this.resultListener = resultListener;
            this.builder = new InMemCubeBuilder2(DoggedCubeBuilder2.this.cuboidScheduler, DoggedCubeBuilder2.this.flatDesc, DoggedCubeBuilder2.this.dictionaryMap);
            this.builder.setReserveMemoryMB(DoggedCubeBuilder2.this.reserveMemoryMB);
            this.builder.setConcurrentThreads(DoggedCubeBuilder2.this.taskThreadCount);
            logger.info("Split #" + splitSeq + " kickoff");
        }

        @Override
        protected CuboidResult compute() {
            try {
                CuboidResult baseCuboidResult = this.builder.buildBaseCuboid(this.inputController, this.resultListener);
                if (!this.inputController.ifEnd()) {
                    this.next = new BaseCuboidTask<T>(this.inputController, this.splitSeq + 1, this.resultListener);
                    this.next.fork();
                }
                logger.info("Split #" + this.splitSeq + " finished");
                return baseCuboidResult;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public InMemCubeBuilder2 getInternalBuilder() {
            return this.builder;
        }

        public BaseCuboidTask<T> nextTask() {
            return this.next;
        }
    }

    private class BuildOnce {
        private BuildOnce() {
        }

        public <T> void build(BlockingQueue<T> input, InputConverterUnit<T> inputConverterUnit, ICuboidWriter output) throws IOException {
            RecordConsumeBlockingQueueController<T> inputController = RecordConsumeBlockingQueueController.getQueueController(inputConverterUnit, input);
            CopyOnWriteArrayList<InMemCubeBuilder2> builderList = new CopyOnWriteArrayList<InMemCubeBuilder2>();
            ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    worker.setName("dogged-cubing-cuboid-worker-" + worker.getPoolIndex());
                    return worker;
                }
            };
            ForkJoinPool builderPool = new ForkJoinPool(DoggedCubeBuilder2.this.taskThreadCount, factory, null, true);
            CuboidResultWatcher resultWatcher = new CuboidResultWatcher(builderList, output);
            Stopwatch sw = Stopwatch.createUnstarted();
            sw.start();
            logger.info("Dogged Cube Build2 start");
            try {
                BaseCuboidTask<T> task = new BaseCuboidTask<T>(inputController, 1, resultWatcher);
                builderPool.execute(task);
                do {
                    builderList.add(task.getInternalBuilder());
                    task.join();
                } while ((task = task.nextTask()) != null);
                logger.info("Has finished feeding data, and base cuboid built, start to build child cuboids");
                for (final InMemCubeBuilder2 builder : builderList) {
                    builderPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            builder.startBuildFromBaseCuboid();
                        }
                    });
                }
                resultWatcher.start();
                logger.info("Dogged Cube Build2 splits complete, took " + sw.elapsed(TimeUnit.MILLISECONDS) + " ms");
            }
            catch (Throwable e) {
                logger.error("Dogged Cube Build2 error", e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IOException(e);
            }
            finally {
                output.close();
                this.closeGirdTables(builderList);
                sw.stop();
                builderPool.shutdownNow();
                logger.info("Dogged Cube Build2 end, totally took " + sw.elapsed(TimeUnit.MILLISECONDS) + " ms");
                logger.info("Dogged Cube Build2 return");
            }
        }

        private void closeGirdTables(List<InMemCubeBuilder2> builderList) {
            for (InMemCubeBuilder2 inMemCubeBuilder : builderList) {
                for (CuboidResult cuboidResult : inMemCubeBuilder.getResultCollector().getAllResult().values()) {
                    this.closeGirdTable(cuboidResult.table);
                }
            }
        }

        private void closeGirdTable(GridTable gridTable) {
            try {
                gridTable.close();
            }
            catch (Throwable e) {
                logger.error("Error closing grid table " + gridTable, e);
            }
        }
    }
}

