/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;

public class ShrunkenDictionary<T>
extends Dictionary<T> {
    private ImmutableMap<T, Integer> valueToIdMap;
    private ImmutableMap<Integer, T> idToValueMap;
    private int minId;
    private int maxId;
    private int sizeOfId;
    private int sizeOfValue;
    private ValueSerializer<T> valueSerializer;

    public ShrunkenDictionary(ValueSerializer<T> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public ShrunkenDictionary(ValueSerializer<T> valueSerializer, int minId, int maxId, int sizeOfId, int sizeOfValue, Map<T, Integer> valueToIdMap) {
        this.valueSerializer = valueSerializer;
        this.minId = minId;
        this.maxId = maxId;
        this.sizeOfId = sizeOfId;
        this.sizeOfValue = sizeOfValue;
        Preconditions.checkNotNull(valueToIdMap);
        this.valueToIdMap = ImmutableMap.builder().putAll(valueToIdMap).build();
    }

    @Override
    public int getMinId() {
        return this.minId;
    }

    @Override
    public int getMaxId() {
        return this.maxId;
    }

    @Override
    public int getSizeOfId() {
        return this.sizeOfId;
    }

    @Override
    public int getSizeOfValue() {
        return this.sizeOfValue;
    }

    @Override
    public boolean contains(Dictionary<?> another) {
        return false;
    }

    @Override
    protected int getIdFromValueImpl(T value, int roundingFlag) {
        Integer id = this.valueToIdMap.get(value);
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    protected T getValueFromIdImpl(int id) {
        if (this.idToValueMap == null) {
            this.idToValueMap = this.buildIdToValueMap();
        }
        return this.idToValueMap.get(id);
    }

    private ImmutableMap<Integer, T> buildIdToValueMap() {
        ImmutableMap.Builder idToValueMapBuilder = ImmutableMap.builder();
        for (Object value : this.valueToIdMap.keySet()) {
            idToValueMapBuilder.put(this.valueToIdMap.get(value), value);
        }
        return idToValueMapBuilder.build();
    }

    @Override
    public void dump(PrintStream out) {
        out.println(String.format(Locale.ROOT, "Total %d values for ShrunkenDictionary", this.valueToIdMap.size()));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.minId);
        out.writeInt(this.maxId);
        out.writeInt(this.sizeOfId);
        out.writeInt(this.sizeOfValue);
        out.writeInt(this.valueToIdMap.size());
        for (Object value : this.valueToIdMap.keySet()) {
            this.valueSerializer.writeValue(out, value);
            out.writeInt(this.valueToIdMap.get(value));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.minId = in.readInt();
        this.maxId = in.readInt();
        this.sizeOfId = in.readInt();
        this.sizeOfValue = in.readInt();
        int sizeValueMap = in.readInt();
        ImmutableMap.Builder<T, Integer> valueToIdMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < sizeValueMap; ++i) {
            T value = this.valueSerializer.readValue(in);
            int id = in.readInt();
            valueToIdMapBuilder.put(value, id);
        }
        this.valueToIdMap = valueToIdMapBuilder.build();
    }

    public static class StringValueSerializer
    implements ValueSerializer<String> {
        @Override
        public void writeValue(DataOutput out, String value) throws IOException {
            out.writeUTF(value);
        }

        @Override
        public String readValue(DataInput in) throws IOException {
            return in.readUTF();
        }
    }

    public static interface ValueSerializer<T> {
        public void writeValue(DataOutput var1, T var2) throws IOException;

        public T readValue(DataInput var1) throws IOException;
    }
}

