/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.dict.lookup.SnapshotTable;

public class SnapshotTableSerializer
implements Serializer<SnapshotTable> {
    public static final SnapshotTableSerializer FULL_SERIALIZER = new SnapshotTableSerializer(false);
    public static final SnapshotTableSerializer INFO_SERIALIZER = new SnapshotTableSerializer(true);
    private boolean infoOnly;

    SnapshotTableSerializer(boolean infoOnly) {
        this.infoOnly = infoOnly;
    }

    @Override
    public void serialize(SnapshotTable obj, DataOutputStream out) throws IOException {
        String json = JsonUtil.writeValueAsIndentString(obj);
        out.writeUTF(json);
        if (!this.infoOnly) {
            obj.writeData(out);
        }
    }

    @Override
    public SnapshotTable deserialize(DataInputStream in) throws IOException {
        String json = in.readUTF();
        SnapshotTable obj = JsonUtil.readValue(json, SnapshotTable.class);
        if (!this.infoOnly) {
            obj.readData(in);
        }
        return obj;
    }
}

