/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.util.HashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.flink.FlinkCubingByLayer;
import org.apache.kylin.engine.flink.FlinkExecutable;
import org.apache.kylin.engine.flink.FlinkFactDistinctColumns;
import org.apache.kylin.engine.flink.FlinkUtil;
import org.apache.kylin.engine.flink.IFlinkInput;
import org.apache.kylin.engine.flink.IFlinkOutput;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkBatchCubingJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(FlinkBatchCubingJobBuilder2.class);
    private final IFlinkInput.IFlinkBatchCubingInputSide inputSide;
    private final IFlinkOutput.IFlinkBatchCubingOutputSide outputSide;

    public FlinkBatchCubingJobBuilder2(CubeSegment newSegment, String submitter, Integer priorityOffset) {
        super(newSegment, submitter, priorityOffset);
        this.inputSide = FlinkUtil.getBatchCubingInputSide(this.seg);
        this.outputSide = FlinkUtil.getBatchCubingOutputSide(this.seg);
    }

    public CubingJob build() {
        logger.info("Flink job to BUILD segment " + this.seg);
        CubingJob result = CubingJob.createBuildJob(this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isFlinkFactDistinctEnable()) {
            result.addTask(this.createFactDistinctColumnsFlinkStep(jobId));
        } else {
            result.addTask(this.createFactDistinctColumnsStep(jobId));
        }
        if (this.isEnableUHCDictStep()) {
            result.addTask(this.createBuildUHCDictStep(jobId));
        }
        result.addTask(this.createBuildDictionaryStep(jobId));
        result.addTask(this.createSaveStatisticsStep(jobId));
        LookupMaterializeContext lookupMaterializeContext = this.addMaterializeLookupTableSteps(result);
        this.outputSide.addStepPhase2_BuildDictionary(result);
        this.addLayerCubingSteps(result, jobId, cuboidRootPath);
        this.outputSide.addStepPhase3_BuildCube(result);
        result.addTask(this.createUpdateCubeInfoAfterBuildStep(jobId, lookupMaterializeContext));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    public FlinkExecutable createFactDistinctColumnsFlinkStep(String jobId) {
        FlinkExecutable flinkExecutable = new FlinkExecutable();
        IJoinedFlatTableDesc flatTableDesc = EngineFactory.getJoinedFlatTableDesc(this.seg);
        String tablePath = JoinedFlatTable.getTableDir(flatTableDesc, this.getJobWorkingDir(jobId));
        flinkExecutable.setClassName(FlinkFactDistinctColumns.class.getName());
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_CUBE_NAME.getOpt(), this.seg.getRealization().getName());
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_SEGMENT_ID.getOpt(), this.seg.getUuid());
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(this.seg.getConfig(), jobId));
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_INPUT_TABLE.getOpt(), this.seg.getConfig().getHiveDatabaseForIntermediateTable() + "." + flatTableDesc.getTableName());
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_INPUT_PATH.getOpt(), tablePath);
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_OUTPUT_PATH.getOpt(), this.getFactDistinctColumnsPath(jobId));
        flinkExecutable.setParam(FlinkFactDistinctColumns.OPTION_STATS_SAMPLING_PERCENT.getOpt(), String.valueOf(this.config.getConfig().getCubingInMemSamplingPercent()));
        flinkExecutable.setJobId(jobId);
        flinkExecutable.setName("Extract Fact Table Distinct Columns");
        flinkExecutable.setCounterSaveAs("sourceRecordCount,sourceSizeBytes", this.getCounterOutputPath(jobId));
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, this.seg.getConfig().getFlinkAdditionalJars());
        flinkExecutable.setJars(jars.toString());
        return flinkExecutable;
    }

    protected void addLayerCubingSteps(CubingJob result, String jobId, String cuboidRootPath) {
        FlinkExecutable flinkExecutable = new FlinkExecutable();
        flinkExecutable.setClassName(FlinkCubingByLayer.class.getName());
        this.configureFlinkJob(this.seg, flinkExecutable, jobId, cuboidRootPath);
        result.addTask(flinkExecutable);
    }

    public void configureFlinkJob(CubeSegment seg, FlinkExecutable flinkExecutable, String jobId, String cuboidRootPath) {
        IJoinedFlatTableDesc flatTableDesc = EngineFactory.getJoinedFlatTableDesc(seg);
        String tablePath = JoinedFlatTable.getTableDir(flatTableDesc, this.getJobWorkingDir(jobId));
        flinkExecutable.setParam(FlinkCubingByLayer.OPTION_CUBE_NAME.getOpt(), seg.getRealization().getName());
        flinkExecutable.setParam(FlinkCubingByLayer.OPTION_SEGMENT_ID.getOpt(), seg.getUuid());
        flinkExecutable.setParam(FlinkCubingByLayer.OPTION_INPUT_TABLE.getOpt(), seg.getConfig().getHiveDatabaseForIntermediateTable() + "." + flatTableDesc.getTableName());
        flinkExecutable.setParam(FlinkCubingByLayer.OPTION_INPUT_PATH.getOpt(), tablePath);
        flinkExecutable.setParam(FlinkCubingByLayer.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(seg.getConfig(), jobId));
        flinkExecutable.setParam(FlinkCubingByLayer.OPTION_OUTPUT_PATH.getOpt(), cuboidRootPath);
        flinkExecutable.setJobId(jobId);
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, seg.getConfig().getFlinkAdditionalJars());
        flinkExecutable.setJars(jars.toString());
        flinkExecutable.setName("Build Cube with Flink:" + seg.toString());
    }

    @Override
    public String getSegmentMetadataUrl(KylinConfig kylinConfig, String jobId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("path", this.getDumpMetadataPath(jobId));
        return new StorageURL(kylinConfig.getMetadataUrl().getIdentifier(), "hdfs", param).toString();
    }
}

