/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCmdOutput {
    protected static final Logger logger = LoggerFactory.getLogger(HadoopCmdOutput.class);
    private final StringBuilder output;
    private final Job job;
    private String mapInputRecords;
    private String hdfsBytesWritten;
    private String rawInputBytesRead;

    public HadoopCmdOutput(Job job, StringBuilder output) {
        this.job = job;
        this.output = output;
    }

    public String getMrJobId() {
        return this.getInfo().get("mr_job_id");
    }

    public Map<String, String> getInfo() {
        if (this.job != null) {
            HashMap<String, String> status = new HashMap<String, String>();
            if (null != this.job.getJobID()) {
                status.put("mr_job_id", this.job.getJobID().toString());
            }
            if (null != this.job.getTrackingURL()) {
                status.put("yarn_application_tracking_url", this.job.getTrackingURL().toString());
            }
            return status;
        }
        return Collections.emptyMap();
    }

    public String getMapInputRecords() {
        return this.mapInputRecords;
    }

    public String getHdfsBytesWritten() {
        return this.hdfsBytesWritten;
    }

    public String getRawInputBytesRead() {
        return this.rawInputBytesRead;
    }

    public void updateJobCounter() {
        try {
            Counters counters = this.job.getCounters();
            if (counters == null) {
                String errorMsg = "no counters for job " + this.getMrJobId();
                logger.warn(errorMsg);
                this.output.append(errorMsg);
            } else {
                this.output.append(counters.toString()).append("\n");
                logger.debug(counters.toString());
                this.mapInputRecords = String.valueOf(counters.findCounter((Enum)TaskCounter.MAP_INPUT_RECORDS).getValue());
                this.rawInputBytesRead = String.valueOf(counters.findCounter((Enum)FactDistinctColumnsMapper.RawDataCounter.BYTES).getValue());
                String outputFolder = this.job.getConfiguration().get("mapreduce.output.fileoutputformat.outputdir", KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
                logger.debug("outputFolder is " + outputFolder);
                Path outputPath = new Path(outputFolder);
                String fsScheme = outputPath.getFileSystem(this.job.getConfiguration()).getScheme();
                long bytesWritten = counters.findCounter(fsScheme, FileSystemCounter.BYTES_WRITTEN).getValue();
                if (bytesWritten == 0L) {
                    logger.debug("Seems no counter found for " + fsScheme);
                    bytesWritten = counters.findCounter("FileSystemCounters", "HDFS_BYTES_WRITTEN").getValue();
                }
                this.hdfsBytesWritten = String.valueOf(bytesWritten);
            }
            JobStatus jobStatus = this.job.getStatus();
            if (jobStatus.getState() == JobStatus.State.FAILED) {
                logger.warn("Job Diagnostics:" + jobStatus.getFailureInfo());
                this.output.append("Job Diagnostics:").append(jobStatus.getFailureInfo()).append("\n");
                org.apache.hadoop.mapreduce.TaskCompletionEvent taskEvent = this.getOneTaskFailure(this.job);
                if (taskEvent != null) {
                    String[] fails = this.job.getTaskDiagnostics(taskEvent.getTaskAttemptId());
                    logger.warn("Failure task Diagnostics:");
                    this.output.append("Failure task Diagnostics:").append("\n");
                    for (String failure : fails) {
                        logger.warn(failure);
                        this.output.append(failure).append("\n");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            this.output.append(e.getLocalizedMessage());
        }
    }

    private org.apache.hadoop.mapreduce.TaskCompletionEvent getOneTaskFailure(Job job) throws IOException, InterruptedException {
        TaskCompletionEvent lastEvent = null;
        int index = 0;
        int failCount = 0;
        TaskCompletionEvent[] events = job.getTaskCompletionEvents(index);
        if (events == null) {
            return lastEvent;
        }
        while (events.length > 0 && failCount == 0) {
            for (TaskCompletionEvent event : events) {
                if (!event.getStatus().equals((Object)TaskCompletionEvent.Status.FAILED)) continue;
                ++failCount;
                lastEvent = event;
            }
            events = job.getTaskCompletionEvents(index += 10);
        }
        return lastEvent;
    }
}

