/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.streaming.ColumnarSplitDictInputFormat;
import org.apache.kylin.engine.mr.streaming.MergeDictMapper;
import org.apache.kylin.engine.mr.streaming.MergeDictReducer;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeDictJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(MergeDictJob.class);

    public static void main(String[] args) throws Exception {
        MergeDictJob mergeDictJob = new MergeDictJob();
        ToolRunner.run((Tool)mergeDictJob, (String[])args);
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            Path input = new Path(this.getOptionValue(OPTION_INPUT_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String jobName = this.getOptionValue(OPTION_JOB_NAME);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegment(segmentName, SegmentStatusEnum.NEW);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.setJobClasspath(this.job, cube.getConfig());
            this.job.setJobName(jobName);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.name", segmentName);
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{input});
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            logger.info("MergeDictReducer output path: {}", (Object)output);
            this.job.setMapperClass(MergeDictMapper.class);
            this.job.setInputFormatClass(ColumnarSplitDictInputFormat.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setReducerClass(MergeDictReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            this.deletePath(this.job.getConfiguration(), output);
            return this.waitForCompletion(this.job);
        }
        catch (Exception e) {
            this.printUsage(options);
            logger.error("job {} failed. ", (Object)this.job.getJobName(), (Object)e);
            throw e;
        }
    }
}

