/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.dict.lookup.SnapshotTableSerializer;
import org.apache.kylin.engine.mr.SortedColumnDFSFile;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.spark.KylinSparkJobListener;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.SourceManager;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.Tuple3;

public class SparkBuildDictionary
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(SparkBuildDictionary.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_DICT_PATH;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_CUBING_JOB_ID;
    public static final Option OPTION_INPUT_PATH;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_COUNTER_PATH;
    private Options options = new Options();

    public SparkBuildDictionary() {
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_DICT_PATH);
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_CUBING_JOB_ID);
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_COUNTER_PATH);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String dictPath = optionsHelper.getOptionValue(OPTION_DICT_PATH);
        String factColumnsInputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        String jobId = optionsHelper.getOptionValue(OPTION_CUBING_JOB_ID);
        String counterPath = optionsHelper.getOptionValue(OPTION_COUNTER_PATH);
        Class[] kryoClassArray = new Class[]{Class.forName("scala.reflect.ClassTag$$anon$1"), Class.forName("org.apache.kylin.engine.mr.steps.SelfDefineSortableKey"), Class.forName("scala.collection.mutable.WrappedArray$ofRef")};
        SparkConf sparkConf = new SparkConf().setAppName("Build Dimension Dictionary for: " + cubeName + " segment " + segmentId);
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.kryo.registrator", "org.apache.kylin.engine.spark.KylinKryoRegistrator");
        sparkConf.set("spark.kryo.registrationRequired", "true").registerKryoClasses(kryoClassArray);
        KylinSparkJobListener jobListener = new KylinSparkJobListener();
        try (JavaSparkContext sc = new JavaSparkContext(sparkConf);){
            sc.sc().addSparkListener((SparkListenerInterface)jobListener);
            HadoopUtil.deletePath(sc.hadoopConfiguration(), new Path(dictPath));
            LongAccumulator bytesWritten = sc.sc().longAccumulator();
            SerializableConfiguration sConf = new SerializableConfiguration(sc.hadoopConfiguration());
            KylinConfig config = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
            CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
            CubeSegment cubeSegment = cube.getSegmentById(segmentId);
            Set<TblColRef> tblColRefs = cubeSegment.getCubeDesc().getAllColumnsNeedDictionaryBuilt();
            JavaRDD tblColRefRDD = sc.parallelize(Lists.newArrayList(tblColRefs));
            logger.info("Dimensions all is :" + cubeSegment.getCubeDesc().getDimensions().toString());
            List<TblColRef> uhcColumns = cube.getDescriptor().getAllUHCColumns();
            logger.info("Spark build dict uhc columns is " + uhcColumns.size());
            List dictsInfoMap = tblColRefRDD.mapToPair((PairFunction)new DimensionDictsBuildFunction(cubeName, segmentId, config, factColumnsInputPath, dictPath, uhcColumns)).collect();
            cubeSegment = CubeManager.getInstance(config).reloadCube(cubeName).getSegmentById(segmentId);
            JavaRDD dimensionDescRDD = sc.parallelize(cubeSegment.getCubeDesc().getDimensions());
            List snapshotPathMap = dimensionDescRDD.filter((Function)new SnapshotFilterFunction(cubeName, segmentId, config)).mapToPair((PairFunction & Serializable)dimensionDesc -> new Tuple2((Object)dimensionDesc.getTableRef().getTableIdentity(), (Object)dimensionDesc.getTableRef())).groupByKey().mapToPair((PairFunction)new SnapshotBuildFunction(cubeName, segmentId, jobId, config)).filter((Function & Serializable)tuple -> !((String)tuple._2).isEmpty()).collect();
            CubeInstance cubeCopy = cubeSegment.getCubeInstance().latestCopyForWrite();
            CubeSegment segCopy = cubeCopy.getSegmentById(cubeSegment.getUuid());
            for (Tuple2 tuple2 : dictsInfoMap) {
                Tuple3 dictInfo = (Tuple3)tuple2._2;
                segCopy.getDictionaries().put((String)tuple2._1, (String)dictInfo._1());
                segCopy.getRowkeyStats().add(new Object[]{tuple2._1, dictInfo._2(), dictInfo._3()});
            }
            for (Tuple2 tuple2 : snapshotPathMap) {
                segCopy.putSnapshotResPath((String)tuple2._1, (String)tuple2._2);
            }
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToUpdateSegs(segCopy);
            CubeManager.getInstance(config).updateCube(update);
            this.checkSnapshot(CubeManager.getInstance(config), CubeManager.getInstance(config).getCube(cubeName).getSegmentById(segmentId));
            boolean dictsAndSnapshotsBuildState = this.isAllDictsAndSnapshotsReady(config, cubeName, segmentId);
            if (!dictsAndSnapshotsBuildState) {
                logger.error("Not all dictionaries and snapshots ready for cube segment: {}", (Object)segmentId);
            } else {
                logger.info("Succeed to build all dictionaries and snapshots for cube segment: {}", (Object)segmentId);
            }
            long recordCount = tblColRefRDD.count();
            logger.info("Map input records={}", (Object)recordCount);
            logger.info("HDFS Read: {} HDFS Write", (Object)bytesWritten.value());
            logger.info("HDFS: Number of bytes written={}", (Object)jobListener.metrics.getBytesWritten());
            HashMap<String, String> counterMap = Maps.newHashMap();
            counterMap.put("hdfs_bytes_written", String.valueOf(jobListener.metrics.getBytesWritten()));
            counterMap.put("spark_dimension_dic_segment_id", segmentId);
            HadoopUtil.writeToSequenceFile(sc.hadoopConfiguration(), counterPath, counterMap);
        }
    }

    private void checkSnapshot(CubeManager cubeManager, CubeSegment cubeSegment) {
        List<DimensionDesc> dimensionDescs = cubeSegment.getCubeDesc().getDimensions();
        for (DimensionDesc dimensionDesc : dimensionDescs) {
            TableRef lookup = dimensionDesc.getTableRef();
            String tableIdentity = lookup.getTableIdentity();
            if (!cubeSegment.getModel().isLookupTable(tableIdentity) || cubeSegment.getCubeDesc().isExtSnapshotTable(tableIdentity)) continue;
            logger.info("Checking snapshot of {}", (Object)lookup);
            try {
                JoinDesc join = cubeSegment.getModel().getJoinsTree().getJoinByPKSide(lookup);
                ILookupTable table = cubeManager.getLookupTable(cubeSegment, join);
                if (table == null) continue;
                IOUtils.closeStream((Closeable)table);
            }
            catch (Throwable th) {
                throw new RuntimeException(String.format(Locale.ROOT, "Checking snapshot of %s failed.", lookup), th);
            }
        }
    }

    private boolean isAllDictsAndSnapshotsReady(KylinConfig config, String cubeName, String segmentID) {
        CubeManager cubeManager = CubeManager.getInstance(config);
        CubeInstance cube = cubeManager.reloadCube(cubeName);
        CubeSegment segment = cube.getSegmentById(segmentID);
        ResourceStore store = ResourceStore.getStore(config);
        logger.info("Begin to check if all dictionaries exist of Segment: {}", (Object)segmentID);
        Map<String, String> dictionaries = segment.getDictionaries();
        logger.info("Get dictionaries number: {}", (Object)dictionaries.size());
        for (Map.Entry<String, String> entry : dictionaries.entrySet()) {
            String dictResPath = entry.getValue();
            String dictKey = entry.getKey();
            try {
                DictionaryInfo dictInfo = store.getResource(dictResPath, DictionaryInfoSerializer.INFO_SERIALIZER);
                if (dictInfo != null) continue;
                logger.warn("Dictionary=[key: {}, resource path: {}] doesn't exist in resource store", (Object)dictKey, (Object)dictResPath);
                return false;
            }
            catch (IOException e) {
                logger.warn("Dictionary=[key: {}, path: {}] failed to check, details: {}", dictKey, dictResPath, e);
                return false;
            }
        }
        logger.info("Begin to check if all snapshots exist of Segment: {}", (Object)segmentID);
        Map<String, String> snapshots = segment.getSnapshots();
        logger.info("Get snapshot number: {}", (Object)snapshots.size());
        for (Map.Entry<String, String> entry : snapshots.entrySet()) {
            String snapshotKey = entry.getKey();
            String snapshotResPath = entry.getValue();
            try {
                SnapshotTable snapshot = store.getResource(snapshotResPath, SnapshotTableSerializer.INFO_SERIALIZER);
                if (snapshot != null) continue;
                logger.info("SnapshotTable=[key: {}, resource path: {}] doesn't exist in resource store", (Object)snapshotKey, (Object)snapshotResPath);
                return false;
            }
            catch (IOException e) {
                logger.warn("SnapshotTable=[key: {}, resource path: {}]  failed to check, details: {}", snapshotKey, snapshotResPath, e);
                return false;
            }
        }
        logger.info("All dictionaries and snapshots exist checking succeed for Cube Segment: {}", (Object)segmentID);
        return true;
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"dictPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube dictionary output path");
        OPTION_DICT_PATH = OptionBuilder.create((String)"dictPath");
        OptionBuilder.withArgName((String)"segmentId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"cubingJobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cubing job id");
        OPTION_CUBING_JOB_ID = OptionBuilder.create((String)"cubingJobId");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Hive Intermediate Table PATH");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"counterOutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"counter output path");
        OPTION_COUNTER_PATH = OptionBuilder.create((String)"counterOutput");
    }

    static class SnapshotFilterFunction
    implements Function<DimensionDesc, Boolean> {
        private String cubeName;
        private String segmentId;
        private KylinConfig config;
        private CubeSegment cubeSegment;
        private volatile transient boolean initialized = false;

        public SnapshotFilterFunction(String cubeName, String segmentId, KylinConfig config) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.config = config;
        }

        private void init() {
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.config);){
                this.cubeSegment = CubeManager.getInstance(this.config).getCube(this.cubeName).getSegmentById(this.segmentId);
            }
            this.initialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Boolean call(DimensionDesc dimensionDesc) throws Exception {
            if (this.initialized) return !this.cubeSegment.getCubeDesc().isExtSnapshotTable(dimensionDesc.getTableRef().getTableIdentity());
            Class<SparkBuildDictionary> clazz = SparkBuildDictionary.class;
            synchronized (SparkBuildDictionary.class) {
                if (this.initialized) return !this.cubeSegment.getCubeDesc().isExtSnapshotTable(dimensionDesc.getTableRef().getTableIdentity());
                this.init();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return !this.cubeSegment.getCubeDesc().isExtSnapshotTable(dimensionDesc.getTableRef().getTableIdentity());
            }
        }
    }

    static class SnapshotBuildFunction
    implements PairFunction<Tuple2<String, Iterable<TableRef>>, String, String> {
        private String cubeName;
        private String segmentId;
        private String jobId;
        private KylinConfig config;
        private CubeManager cubeManager;
        private CubeSegment cubeSegment;
        private volatile transient boolean initialized = false;

        public SnapshotBuildFunction(String cubeName, String segmentId, String jobId, KylinConfig config) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.jobId = jobId;
            this.config = config;
        }

        private void init() {
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.config);){
                this.cubeManager = CubeManager.getInstance(this.config);
                this.cubeSegment = this.cubeManager.getCube(this.cubeName).getSegmentById(this.segmentId);
            }
            this.initialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Tuple2<String, String> call(Tuple2<String, Iterable<TableRef>> snapShot) throws Exception {
            if (!this.initialized) {
                Class<SparkBuildDictionary> clazz = SparkBuildDictionary.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkBuildDictionary.class
                if (!this.initialized) {
                    this.init();
                }
                // MONITOREXIT : clazz
            }
            String tableIdentity = (String)snapShot._1();
            String snapshotPath = "";
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.config);){
                logger.info("Building snapshot of {}", (Object)tableIdentity);
                if (!this.cubeSegment.getModel().isLookupTable(tableIdentity)) return new Tuple2((Object)tableIdentity, (Object)snapshotPath);
                if (this.cubeSegment.getCubeDesc().isExtSnapshotTable(tableIdentity)) return new Tuple2((Object)tableIdentity, (Object)snapshotPath);
                try {
                    snapshotPath = this.buildSnapshotTable(this.config, this.cubeSegment, tableIdentity, this.jobId);
                    return new Tuple2((Object)tableIdentity, (Object)snapshotPath);
                }
                catch (IOException e) {
                    logger.error("Error while build snapshot table " + tableIdentity + ", " + e.getMessage());
                    Tuple2 tuple2 = new Tuple2((Object)tableIdentity, (Object)snapshotPath);
                    if (autoUnset == null) return tuple2;
                    if (var5_5 != null) {
                        try {
                            autoUnset.close();
                            return tuple2;
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                            return tuple2;
                        }
                    }
                    autoUnset.close();
                    return tuple2;
                }
            }
        }

        private String buildSnapshotTable(KylinConfig config, CubeSegment cubeSeg, String lookupTable, String uuid) throws IOException {
            CubeInstance cubeCopy = cubeSeg.getCubeInstance().latestCopyForWrite();
            CubeSegment segCopy = cubeCopy.getSegmentById(cubeSeg.getUuid());
            TableMetadataManager metaMgr = TableMetadataManager.getInstance(config);
            SnapshotManager snapshotMgr = SnapshotManager.getInstance(config);
            TableDesc tableDesc = new TableDesc(metaMgr.getTableDesc(lookupTable, segCopy.getProject()));
            IReadableTable hiveTable = SourceManager.createReadableTable(tableDesc, uuid);
            SnapshotTable snapshot = snapshotMgr.buildSnapshot(hiveTable, tableDesc, cubeSeg.getConfig());
            return snapshot.getResourcePath();
        }
    }

    static class DimensionDictsBuildFunction
    implements PairFunction<TblColRef, String, Tuple3<String, Integer, Integer>> {
        private volatile transient boolean initialized = false;
        private String cubeName;
        private String segmentId;
        private CubeSegment cubeSegment;
        private DictionaryManager dictManager;
        private KylinConfig config;
        private String factColumnsInputPath;
        private String dictPath;
        private List<TblColRef> uhcColumns;

        public DimensionDictsBuildFunction(String cubeName, String segmentId, KylinConfig config, String factColumnsInputPath, String dictPath, List<TblColRef> uhcColumns) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.config = config;
            this.factColumnsInputPath = factColumnsInputPath;
            this.dictPath = dictPath;
            this.uhcColumns = uhcColumns;
            logger.info("Cube name is {}, segment id is {}", (Object)cubeName, (Object)segmentId);
            logger.info("Fact columns input path is " + factColumnsInputPath);
            logger.info("Fact columns input path is " + dictPath);
        }

        private void init() {
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.config);){
                this.cubeSegment = CubeManager.getInstance(this.config).getCube(this.cubeName).getSegmentById(this.segmentId);
                this.dictManager = DictionaryManager.getInstance(this.config);
            }
            this.initialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Tuple2<String, Tuple3<String, Integer, Integer>> call(TblColRef tblColRef) throws Exception {
            if (!this.initialized) {
                Class<SparkBuildDictionary> clazz = SparkBuildDictionary.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkBuildDictionary.class
                if (!this.initialized) {
                    this.init();
                }
                // MONITOREXIT : clazz
            }
            logger.info("Building dictionary for column {}", (Object)tblColRef);
            IReadableTable inpTable = this.getDistinctValuesFor(tblColRef);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.config);){
                DictionaryInfo dictInfo;
                Dictionary<String> preBuiltDict = this.getDictionary(tblColRef);
                if (preBuiltDict != null) {
                    logger.info("Dict for '{}' has already been built, save it", (Object)tblColRef.getName());
                    dictInfo = this.dictManager.saveDictionary(tblColRef, inpTable, preBuiltDict);
                    return new Tuple2((Object)tblColRef.getIdentity(), (Object)new Tuple3((Object)dictInfo.getResourcePath(), (Object)preBuiltDict.getSize(), (Object)preBuiltDict.getSizeOfId()));
                }
                logger.info("Dict for '{}' not pre-built, build it from {}", (Object)tblColRef.getName(), (Object)inpTable);
                String builderClass = this.cubeSegment.getCubeDesc().getDictionaryBuilderClass(tblColRef);
                dictInfo = this.dictManager.buildDictionary(tblColRef, inpTable, builderClass);
                preBuiltDict = dictInfo.getDictionaryObject();
                return new Tuple2((Object)tblColRef.getIdentity(), (Object)new Tuple3((Object)dictInfo.getResourcePath(), (Object)preBuiltDict.getSize(), (Object)preBuiltDict.getSizeOfId()));
            }
        }

        public IReadableTable getDistinctValuesFor(TblColRef col) {
            return new SortedColumnDFSFile(this.factColumnsInputPath + "/" + col.getIdentity(), col.getType());
        }

        /*
         * Exception decompiling
         */
        public Dictionary<String> getDictionary(TblColRef col) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

