/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.impl.threadpool.FetcherRunner;
import org.apache.kylin.job.impl.threadpool.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFetcherRunner
extends FetcherRunner {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFetcherRunner.class);

    public DefaultFetcherRunner(JobEngineConfig jobEngineConfig, DefaultContext context, JobExecutor jobExecutor) {
        super(jobEngineConfig, context, jobExecutor);
    }

    @Override
    public synchronized void run() {
        try (SetThreadName ignored = new SetThreadName("FetcherRunner %s", System.identityHashCode(this));){
            Map<String, Executable> runningJobs = this.context.getRunningJobs();
            if (this.isJobPoolFull()) {
                return;
            }
            nRunning = 0;
            nReady = 0;
            nStopped = 0;
            nOthers = 0;
            nError = 0;
            nDiscarded = 0;
            nSUCCEED = 0;
            for (String id : this.getExecutableManager().getAllJobIdsInCache()) {
                Output outputDigest;
                if (this.isJobPoolFull()) {
                    return;
                }
                if (runningJobs.containsKey(id)) {
                    ++nRunning;
                    continue;
                }
                if (this.succeedJobs.contains(id)) {
                    ++nSUCCEED;
                    continue;
                }
                try {
                    outputDigest = this.getExecutableManager().getOutputDigest(id);
                }
                catch (IllegalArgumentException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("job " + id + " output digest is null.", e);
                    }
                    ++nOthers;
                    continue;
                }
                if (outputDigest.getState() != ExecutableState.READY) {
                    this.jobStateCount(id);
                    continue;
                }
                AbstractExecutable executable = this.getExecutableManager().getJob(id);
                if (executable == null) {
                    logger.info("job " + id + " get job is null, skip.");
                    ++nOthers;
                    continue;
                }
                if (!executable.isReady()) {
                    ++nOthers;
                    continue;
                }
                KylinConfig config = this.jobEngineConfig.getConfig();
                if (config.isSchedulerSafeMode()) {
                    String cubeName = executable.getCubeName();
                    String projectName = CubeManager.getInstance(config).getCube(cubeName).getProject();
                    if (!config.getSafeModeRunnableProjects().contains(projectName) && executable.getStartTime() == 0L) {
                        logger.info("New job is pending for scheduler in safe mode. Project: {}, job: {}", (Object)projectName, (Object)executable.getName());
                        continue;
                    }
                }
                ++nReady;
                this.addToJobPool(executable, executable.getDefaultPriority());
            }
            this.fetchFailed = false;
            logger.info("Job Fetcher: " + nRunning + " should running, " + runningJobs.size() + " actual running, " + nStopped + " stopped, " + nReady + " ready, " + nSUCCEED + " already succeed, " + nError + " error, " + nDiscarded + " discarded, " + nOthers + " others");
        }
        catch (Throwable th) {
            this.fetchFailed = true;
            logger.warn("Job Fetcher caught a exception ", th);
        }
    }
}

