/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap;

import org.apache.kylin.job.shaded.org.roaringbitmap.ArrayContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.BitmapContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.Container;
import org.apache.kylin.job.shaded.org.roaringbitmap.IntIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.ReverseArrayContainerShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.ReverseBitmapContainerShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.ReverseRunContainerShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.RoaringBitmap;
import org.apache.kylin.job.shaded.org.roaringbitmap.RunContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.ShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.Util;

public class ReverseIntIteratorFlyweight
implements IntIterator {
    private int hs;
    private ShortIterator iter;
    private ReverseArrayContainerShortIterator arrIter = new ReverseArrayContainerShortIterator();
    private ReverseBitmapContainerShortIterator bitmapIter = new ReverseBitmapContainerShortIterator();
    private ReverseRunContainerShortIterator runIter = new ReverseRunContainerShortIterator();
    private short pos;
    private RoaringBitmap roaringBitmap = null;

    public ReverseIntIteratorFlyweight() {
    }

    public ReverseIntIteratorFlyweight(RoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public IntIterator clone() {
        try {
            ReverseIntIteratorFlyweight x = (ReverseIntIteratorFlyweight)super.clone();
            x.iter = this.iter.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            this.pos = (short)(this.pos - 1);
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos >= 0) {
            Container container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof BitmapContainer) {
                this.bitmapIter.wrap(((BitmapContainer)container).bitmap);
                this.iter = this.bitmapIter;
            } else if (container instanceof ArrayContainer) {
                this.arrIter.wrap((ArrayContainer)container);
                this.iter = this.arrIter;
            } else {
                this.runIter.wrap((RunContainer)container);
                this.iter = this.runIter;
            }
            this.hs = Util.toIntUnsigned(this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos)) << 16;
        }
    }

    public void wrap(RoaringBitmap r) {
        this.roaringBitmap = r;
        this.hs = 0;
        this.pos = (short)(this.roaringBitmap.highLowContainer.size() - 1);
        this.nextContainer();
    }
}

