/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap.buffer;

import org.apache.kylin.job.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.Util;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;

final class RawArrayContainerShortIterator
implements PeekableShortIterator {
    int pos;
    MappeableArrayContainer parent;
    short[] content;

    RawArrayContainerShortIterator(MappeableArrayContainer p) {
        this.parent = p;
        if (!p.isArrayBacked()) {
            throw new RuntimeException("internal bug");
        }
        this.content = p.content.array();
        this.pos = 0;
    }

    @Override
    public void advanceIfNeeded(short minval) {
        this.pos = Util.advanceUntil(this.content, this.pos - 1, this.parent.cardinality, minval);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public short next() {
        return this.content[this.pos++];
    }

    @Override
    public int nextAsInt() {
        return BufferUtil.toIntUnsigned(this.content[this.pos++]);
    }

    @Override
    public short peekNext() {
        return this.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.remove((short)(this.pos - 1));
        --this.pos;
    }
}

