/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;

public class AggregateMultipleExpandRule
extends RelOptRule {
    public static final AggregateMultipleExpandRule INSTANCE = new AggregateMultipleExpandRule(AggregateMultipleExpandRule.operand(LogicalAggregate.class, null, new Predicate<Aggregate>(){

        @Override
        public boolean apply(@Nullable Aggregate input) {
            return input.getGroupType() != Aggregate.Group.SIMPLE;
        }
    }, AggregateMultipleExpandRule.operand(RelNode.class, AggregateMultipleExpandRule.any()), new RelOptRuleOperand[0]), "AggregateMultipleExpandRule");

    private AggregateMultipleExpandRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    private static List<ImmutableBitSet> asList(ImmutableBitSet groupSet) {
        ArrayList<ImmutableBitSet> l = new ArrayList<ImmutableBitSet>(1);
        l.add(groupSet);
        return l;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggr = (LogicalAggregate)call.getRelList().get(0);
        RelNode input = aggr.getInput();
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = aggr.getCluster().getRexBuilder();
        for (ImmutableBitSet groupSet : aggr.getGroupSets()) {
            relBuilder.push(aggr.copy(aggr.getTraitSet(), input, false, groupSet, (List)AggregateMultipleExpandRule.asList(groupSet), (List)aggr.getAggCallList()));
            ImmutableList.Builder rexNodes = new ImmutableList.Builder();
            int index = 0;
            Iterator<Integer> groupSetIter = aggr.getGroupSet().iterator();
            Iterator<RelDataTypeField> typeIterator = aggr.getRowType().getFieldList().iterator();
            Iterator<Integer> groupKeyIter = groupSet.iterator();
            int groupKey = groupKeyIter.next();
            while (groupSetIter.hasNext()) {
                Integer aggrGroupKey = groupSetIter.next();
                RelDataType type = typeIterator.next().getType();
                if (groupKey == aggrGroupKey) {
                    rexNodes.add(rexBuilder.makeInputRef(type, index++));
                    groupKey = groupKeyIter.next();
                    continue;
                }
                rexNodes.add(rexBuilder.makeNullLiteral(type));
            }
            while (typeIterator.hasNext()) {
                RelDataType type = typeIterator.next().getType();
                rexNodes.add(rexBuilder.makeInputRef(type, index++));
            }
            relBuilder.project(rexNodes.build());
        }
        RelNode unionAggr = relBuilder.union(true, aggr.getGroupSets().size()).build();
        call.transformTo(unionAggr);
    }
}

