/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableUnion;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.ExtendedEnumerable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.EqualityComparer;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.BuiltInMethod;

public class KylinEnumerableUnion
extends EnumerableUnion {
    private Method unionArray = Types.lookupMethod(ExtendedEnumerable.class, "union", Enumerable.class, EqualityComparer.class);
    private Method arrayComparer = Types.lookupMethod(Functions.class, "arrayComparer", new Class[0]);

    public KylinEnumerableUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
    }

    private Expression createUnionExpression(Expression left, Expression right, boolean arrayInput) {
        if (this.all) {
            return Expressions.call(left, BuiltInMethod.CONCAT.method, right);
        }
        return arrayInput ? Expressions.call(left, this.unionArray, right, Expressions.call(this.arrayComparer, new Expression[0])) : Expressions.call(left, BuiltInMethod.UNION.method, right);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        Expression unionExp = null;
        for (Ord ord : Ord.zip(this.inputs)) {
            EnumerableRel input = (EnumerableRel)ord.e;
            EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
            Expression childExp = builder.append("child" + ord.i, result.block);
            if (unionExp == null) {
                unionExp = childExp;
                continue;
            }
            unionExp = this.createUnionExpression(unionExp, childExp, result.format == JavaRowFormat.ARRAY);
        }
        builder.add(unionExp);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        return implementor.result(physType, builder.toBlock());
    }
}

