/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConfigManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<KafkaConfig> kafkaMap;
    private CachedCrudAssist<KafkaConfig> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static KafkaConfigManager getInstance(KylinConfig config) {
        return config.getManager(KafkaConfigManager.class);
    }

    static KafkaConfigManager newInstance(KylinConfig config) throws IOException {
        return new KafkaConfigManager(config);
    }

    private KafkaConfigManager(KylinConfig config) throws IOException {
        this.config = config;
        this.kafkaMap = new CaseInsensitiveStringCache(config, "kafka");
        this.crud = new CachedCrudAssist<KafkaConfig>(this.getStore(), "/kafka", KafkaConfig.class, this.kafkaMap){

            @Override
            protected KafkaConfig initEntityAfterReload(KafkaConfig t, String resourceName) {
                return t;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(config).registerListener(new KafkaSyncListener(), "kafka");
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public KafkaConfig getKafkaConfig(String name) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            KafkaConfig kafkaConfig = (KafkaConfig)this.kafkaMap.get(name);
            return kafkaConfig;
        }
    }

    public List<KafkaConfig> listAllKafkaConfigs() {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            ArrayList<KafkaConfig> arrayList = new ArrayList<KafkaConfig>(this.kafkaMap.values());
            return arrayList;
        }
    }

    public boolean createKafkaConfig(KafkaConfig kafkaConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            if (this.kafkaMap.containsKey(kafkaConfig.resourceName())) {
                throw new IllegalArgumentException("KafkaConfig '" + kafkaConfig.getName() + "' already exists");
            }
            kafkaConfig.updateRandomUuid();
            this.checkKafkaConfig(kafkaConfig);
            this.crud.save(kafkaConfig);
            boolean bl = true;
            return bl;
        }
    }

    public KafkaConfig updateKafkaConfig(KafkaConfig kafkaConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            if (!this.kafkaMap.containsKey(kafkaConfig.resourceName())) {
                throw new IllegalArgumentException("KafkaConfig '" + kafkaConfig.getName() + "' does not exist.");
            }
            this.checkKafkaConfig(kafkaConfig);
            KafkaConfig kafkaConfig2 = this.crud.save(kafkaConfig);
            return kafkaConfig2;
        }
    }

    private void checkKafkaConfig(KafkaConfig kafkaConfig) {
        if (kafkaConfig == null || StringUtils.isEmpty(kafkaConfig.getName())) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty(kafkaConfig.getTopic())) {
            throw new IllegalArgumentException("No topic info");
        }
        if (kafkaConfig.getKafkaClusterConfigs() == null || kafkaConfig.getKafkaClusterConfigs().size() == 0) {
            throw new IllegalArgumentException("No cluster info");
        }
    }

    public void removeKafkaConfig(KafkaConfig kafkaConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.delete(kafkaConfig);
        }
    }

    private class KafkaSyncListener
    extends Broadcaster.Listener {
        private KafkaSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = KafkaConfigManager.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    KafkaConfigManager.this.kafkaMap.removeLocal(cacheKey);
                } else {
                    KafkaConfigManager.this.crud.reloadQuietly(cacheKey);
                }
            }
        }
    }
}

