/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CuboidShardUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.CubeHTableUtil;
import org.apache.kylin.storage.hbase.steps.HFileOutputFormat3;
import org.apache.kylin.storage.hbase.steps.RowKeyWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHTableJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CreateHTableJob.class);
    CubeInstance cube = null;
    CubeDesc cubeDesc = null;
    String segmentID = null;
    String cuboidModeName = null;
    String hbaseConfPath = null;
    KylinConfig kylinConfig;
    Path partitionFilePath;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(OPTION_CUBE_NAME);
        options.addOption(OPTION_SEGMENT_ID);
        options.addOption(OPTION_PARTITION_FILE_PATH);
        options.addOption(OPTION_CUBOID_MODE);
        options.addOption(OPTION_HBASE_CONF_PATH);
        this.parseOptions(options, args);
        this.partitionFilePath = new Path(this.getOptionValue(OPTION_PARTITION_FILE_PATH));
        String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
        CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        this.cube = cubeMgr.getCube(cubeName);
        this.cubeDesc = this.cube.getDescriptor();
        this.kylinConfig = this.cube.getConfig();
        this.segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
        this.cuboidModeName = this.getOptionValue(OPTION_CUBOID_MODE);
        this.hbaseConfPath = this.getOptionValue(OPTION_HBASE_CONF_PATH);
        CubeSegment cubeSegment = this.cube.getSegmentById(this.segmentID);
        Map<Long, Double> cuboidSizeMap = new CubeStatsReader(cubeSegment, this.kylinConfig).getCuboidSizeMap();
        Set<Long> buildingCuboids = this.cube.getCuboidsByMode(this.cuboidModeName);
        if (buildingCuboids != null && !buildingCuboids.isEmpty()) {
            logger.info("CreateHTableJob buildingCuboids size: " + buildingCuboids.size());
            HashMap<Long, Double> optimizedCuboidSizeMap = Maps.newHashMapWithExpectedSize(buildingCuboids.size());
            for (Long cuboid : buildingCuboids) {
                Double cuboidSize = cuboidSizeMap.get(cuboid);
                if (cuboidSize == null) {
                    logger.warn("{} cuboid's size is null will replace by 0", (Object)cuboid);
                    cuboidSize = 0.0;
                }
                logger.info("Cuboid:" + cuboid + " size: " + cuboidSize);
                optimizedCuboidSizeMap.put(cuboid, cuboidSize);
            }
            cuboidSizeMap = optimizedCuboidSizeMap;
        }
        byte[][] splitKeys = CreateHTableJob.getRegionSplitsFromCuboidStatistics(cuboidSizeMap, this.kylinConfig, cubeSegment, this.partitionFilePath.getParent());
        CubeHTableUtil.createHTable(cubeSegment, splitKeys, true);
        if (this.cubeDesc.getEngineType() == 4 || this.cubeDesc.getEngineType() == 5) {
            this.exportHBaseConfiguration(cubeSegment.getStorageLocationIdentifier());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportHBaseConfiguration(String hbaseTableName) throws IOException {
        Configuration hbaseConf = HBaseConnection.getCurrentHBaseConfiguration();
        HadoopUtil.healSickConfig(hbaseConf);
        Job job = Job.getInstance((Configuration)hbaseConf, (String)hbaseTableName);
        HTable table = new HTable(hbaseConf, hbaseTableName);
        HFileOutputFormat3.configureIncrementalLoadMap(job, (Table)table);
        logger.info("Saving HBase configuration to {}", (Object)this.hbaseConfPath);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        FSDataOutputStream out = null;
        try {
            out = fs.create(new Path(this.hbaseConfPath));
            job.getConfiguration().writeXml((OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static byte[][] getSplitsByRegionCount(int regionCount) {
        byte[][] result = new byte[regionCount - 1][];
        for (int i = 1; i < regionCount; ++i) {
            byte[] split = new byte[2];
            BytesUtil.writeUnsigned(i, split, 0, 2);
            result[i - 1] = split;
        }
        return result;
    }

    public static byte[][] getRegionSplitsFromCuboidStatistics(Map<Long, Double> cubeSizeMap, KylinConfig kylinConfig, CubeSegment cubeSegment, Path hfileSplitsOutputFolder) throws IOException {
        CubeDesc cubeDesc = cubeSegment.getCubeDesc();
        float cut = cubeDesc.getConfig().getKylinHBaseRegionCut();
        logger.info("Cut for HBase region is {} GB", (Object)Float.valueOf(cut));
        double totalSizeInM = 0.0;
        for (Double cuboidSize : cubeSizeMap.values()) {
            totalSizeInM += cuboidSize.doubleValue();
        }
        ArrayList<Long> allCuboids = Lists.newArrayList();
        allCuboids.addAll(cubeSizeMap.keySet());
        Collections.sort(allCuboids);
        int nRegion = Math.round((float)(totalSizeInM / (double)(cut * 1024.0f)));
        nRegion = Math.max(kylinConfig.getHBaseRegionCountMin(), nRegion);
        nRegion = Math.min(kylinConfig.getHBaseRegionCountMax(), nRegion);
        if (cubeSegment.isEnableSharding()) {
            int original = nRegion;
            if (nRegion == 0) {
                nRegion = 1;
            }
            if (nRegion > Short.MAX_VALUE) {
                logger.info("Too many regions! reduce to {}", (Object)Short.MAX_VALUE);
                nRegion = Short.MAX_VALUE;
            }
            if (nRegion != original) {
                logger.info("Region count is adjusted from {} to {} to help random sharding", (Object)original, (Object)nRegion);
            }
        }
        int mbPerRegion = (int)(totalSizeInM / (double)nRegion);
        mbPerRegion = Math.max(1, mbPerRegion);
        logger.info("Total size {} M (estimated)", (Object)totalSizeInM);
        logger.info("Expecting {} regions.", (Object)nRegion);
        logger.info("Expecting {} MB per region.", (Object)mbPerRegion);
        if (cubeSegment.isEnableSharding()) {
            HashMap<Long, Short> cuboidShards = Maps.newHashMap();
            ArrayList<HashMap<Long, Double>> innerRegionSplits = Lists.newArrayList();
            for (int i = 0; i < nRegion; ++i) {
                innerRegionSplits.add(new HashMap());
            }
            double[] regionSizes = new double[nRegion];
            Iterator iterator = allCuboids.iterator();
            while (iterator.hasNext()) {
                short startShard;
                double magic;
                long cuboidId = (Long)iterator.next();
                double estimatedSize = cubeSizeMap.get(cuboidId);
                int shardNum = (int)(estimatedSize * (magic = 23.0) / (double)mbPerRegion + 1.0);
                if (shardNum < 1) {
                    shardNum = 1;
                }
                if (shardNum > nRegion) {
                    logger.debug(String.format(Locale.ROOT, "Cuboid %d 's estimated size %.2f MB will generate %d regions, reduce to %d", cuboidId, estimatedSize, shardNum, nRegion));
                    shardNum = nRegion;
                } else {
                    logger.debug(String.format(Locale.ROOT, "Cuboid %d 's estimated size %.2f MB will generate %d regions", cuboidId, estimatedSize, shardNum));
                }
                cuboidShards.put(cuboidId, (short)shardNum);
                for (short i = startShard = ShardingHash.getShard(cuboidId, nRegion); i < startShard + shardNum; i = (short)(i + 1)) {
                    short j = (short)(i % nRegion);
                    regionSizes[j] = regionSizes[j] + estimatedSize / (double)shardNum;
                    ((HashMap)innerRegionSplits.get(j)).put(cuboidId, estimatedSize / (double)shardNum);
                }
            }
            for (int i = 0; i < nRegion; ++i) {
                logger.debug("Region {}'s estimated size is {} MB, accounting for {} percent", i, regionSizes[i], 100.0 * regionSizes[i] / totalSizeInM);
            }
            CuboidShardUtil.saveCuboidShards(cubeSegment, cuboidShards, nRegion);
            CreateHTableJob.saveHFileSplits(innerRegionSplits, mbPerRegion, hfileSplitsOutputFolder, kylinConfig);
            return CreateHTableJob.getSplitsByRegionCount(nRegion);
        }
        throw new IllegalStateException("Not supported");
    }

    protected static void saveHFileSplits(List<HashMap<Long, Double>> innerRegionSplits, int mbPerRegion, Path outputFolder, KylinConfig kylinConfig) throws IOException {
        float hfileSizeGB;
        float hfileSizeMB;
        if (outputFolder == null) {
            logger.warn("outputFolder for hfile split file is null, skip inner region split");
            return;
        }
        Configuration hbaseConf = HBaseConnection.getCurrentHBaseConfiguration();
        FileSystem fs = HadoopUtil.getFileSystem(outputFolder, hbaseConf);
        if (!fs.exists(outputFolder)) {
            fs.mkdirs(outputFolder);
        }
        if ((hfileSizeMB = (hfileSizeGB = kylinConfig.getHBaseHFileSizeGB()) * 1024.0f) > (float)mbPerRegion) {
            hfileSizeMB = mbPerRegion;
        }
        if (hfileSizeMB > 0.0f && kylinConfig.isDevEnv()) {
            hfileSizeMB = (float)mbPerRegion / 2.0f;
        }
        int compactionThreshold = kylinConfig.getHBaseRegionCompactionThreshold();
        logger.info("kylin.storage.hbase.region-compaction-threshold is " + compactionThreshold);
        if (hfileSizeMB > 0.0f && hfileSizeMB * (float)compactionThreshold < (float)mbPerRegion) {
            hfileSizeMB = (float)mbPerRegion / (float)compactionThreshold;
        }
        if (hfileSizeMB <= 0.0f) {
            hfileSizeMB = mbPerRegion;
        }
        logger.info("hfileSizeMB {}", (Object)Float.valueOf(hfileSizeMB));
        Path hfilePartitionFile = new Path(outputFolder, "part-r-00000_hfile");
        int regionCount = innerRegionSplits.size();
        ArrayList<byte[]> splits = Lists.newArrayList();
        for (int i = 0; i < regionCount; ++i) {
            if (i > 0) {
                byte[] split = new byte[2];
                BytesUtil.writeUnsigned(i, split, 0, 2);
                splits.add(split);
            }
            HashMap<Long, Double> cuboidSize = innerRegionSplits.get(i);
            ArrayList<Long> allCuboids = Lists.newArrayList();
            allCuboids.addAll(cuboidSize.keySet());
            Collections.sort(allCuboids);
            double accumulatedSize = 0.0;
            int j = 0;
            for (Long cuboid : allCuboids) {
                if (accumulatedSize >= (double)hfileSizeMB) {
                    logger.debug("Region {}'s hfile {} size is {} mb", i, j, accumulatedSize);
                    byte[] split = new byte[10];
                    BytesUtil.writeUnsigned(i, split, 0, 2);
                    System.arraycopy(Bytes.toBytes(cuboid), 0, split, 2, 8);
                    splits.add(split);
                    accumulatedSize = 0.0;
                    ++j;
                }
                accumulatedSize += cuboidSize.get(cuboid).doubleValue();
            }
        }
        try (SequenceFile.Writer hfilePartitionWriter = SequenceFile.createWriter((Configuration)hbaseConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)hfilePartitionFile), SequenceFile.Writer.keyClass(RowKeyWritable.class), SequenceFile.Writer.valueClass(NullWritable.class)});){
            for (int i = 0; i < splits.size(); ++i) {
                hfilePartitionWriter.append((Writable)new RowKeyWritable(KeyValueUtil.createFirstOnRow((byte[])((byte[])splits.get(i)), (long)Long.MAX_VALUE).createKeyOnly(false).getKey()), (Writable)NullWritable.get());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new CreateHTableJob(), (String[])args);
        System.exit(exitCode);
    }
}

