/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.consumer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.job.shaded.com.codahale.metrics.Meter;
import org.apache.kylin.job.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.consumer.IStopConsumptionCondition;
import org.apache.kylin.stream.core.consumer.IStreamingConnector;
import org.apache.kylin.stream.core.exception.IllegalStorageException;
import org.apache.kylin.stream.core.exception.StreamingException;
import org.apache.kylin.stream.core.metrics.StreamingMetrics;
import org.apache.kylin.stream.core.model.StreamingMessage;
import org.apache.kylin.stream.core.model.stats.ConsumerStats;
import org.apache.kylin.stream.core.model.stats.PartitionConsumeStats;
import org.apache.kylin.stream.core.source.MessageFormatException;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.stream.core.storage.StreamingSegmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingConsumerChannel
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StreamingConsumerChannel.class);
    protected volatile boolean stopped;
    protected volatile boolean paused;
    protected volatile boolean hasStoppedConsuming;
    private volatile CountDownLatch pauseLatch;
    private volatile CountDownLatch stopLatch;
    private Thread consumerThread;
    private String cubeName;
    private IStreamingConnector connector;
    private StreamingSegmentManager cubeSegmentManager;
    private volatile IStopConsumptionCondition stopCondition;
    private volatile long minAcceptEventTime;
    private AtomicLong parseEventErrorCnt = new AtomicLong(0L);
    private AtomicLong addEventErrorCnt = new AtomicLong(0L);
    private AtomicLong incomingEventCnt = new AtomicLong(0L);
    private AtomicLong dropEventCnt = new AtomicLong(0L);
    private Map<Integer, Meter> eventConsumeMeters;

    public StreamingConsumerChannel(String cubeName, IStreamingConnector connector, StreamingSegmentManager cubeSegmentManager, IStopConsumptionCondition stopCondition) {
        this.connector = connector;
        this.cubeName = cubeName;
        this.cubeSegmentManager = cubeSegmentManager;
        this.stopCondition = stopCondition;
        this.stopLatch = new CountDownLatch(1);
        this.eventConsumeMeters = Maps.newHashMap();
        this.minAcceptEventTime = 0L;
    }

    public void setStopCondition(IStopConsumptionCondition stopCondition) {
        this.stopCondition = stopCondition;
        this.stopCondition.init(this.connector.getConsumePartitions());
    }

    public void setMinAcceptEventTime(long minAcceptEventTime) {
        this.minAcceptEventTime = minAcceptEventTime;
    }

    public void start() {
        this.consumerThread = new Thread((Runnable)this, this.cubeName + "_channel");
        this.consumerThread.setPriority(10);
        this.connector.open();
        this.consumerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            if (!this.paused) {
                long countValue;
                StreamingMessage event = null;
                try {
                    event = this.connector.nextEvent();
                    if (event == null) {
                        Thread.sleep(100L);
                        continue;
                    }
                    this.incomingEventCnt.incrementAndGet();
                    this.recordConsumeMetric(event.getSourcePosition().getPartition(), event.getParams());
                    if (!this.stopCondition.isSatisfied(event)) {
                        if (this.isFilter(event)) continue;
                        this.cubeSegmentManager.addEvent(event);
                        continue;
                    }
                    logger.warn("The latest event trigger stopCondition, event = " + event);
                    this.stopped = true;
                    continue;
                }
                catch (MessageFormatException mfe) {
                    countValue = this.parseEventErrorCnt.incrementAndGet();
                    if (countValue % 1000L >= 3L) continue;
                    logger.error(mfe.getMessage(), mfe);
                    continue;
                }
                catch (InterruptedException ie) {
                    logger.warn("interrupted!");
                    this.stopped = true;
                    continue;
                }
                catch (IllegalStorageException ise) {
                    logger.error("Encountering unrecoverable exception, stopping consumer thread! {}", (Object)ise.getMessage(), (Object)ise);
                    throw ise;
                }
                catch (Exception e) {
                    countValue = this.addEventErrorCnt.incrementAndGet();
                    if (countValue % 1000L >= 3L) continue;
                    logger.error("error happens when save event:" + event, e);
                    continue;
                }
            }
            try {
                if (this.pauseLatch != null) {
                    this.pauseLatch.countDown();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.warn("interrupted!");
                this.stopped = true;
            }
        }
        this.hasStoppedConsuming = true;
        logger.warn("Exit from main event loop, start to close cubeSegmentManager.");
        try {
            this.cubeSegmentManager.close();
            this.removeMetrics();
        }
        finally {
            this.connector.close();
            this.stopLatch.countDown();
        }
    }

    private void removeMetrics() {
        for (Map.Entry<Integer, Meter> meterEntry : this.eventConsumeMeters.entrySet()) {
            StreamingMetrics.getInstance().getMetricRegistry().remove(MetricRegistry.name("streaming.events.consume.cnt", this.cubeName, String.valueOf(meterEntry.getKey())));
        }
    }

    protected void recordConsumeMetric(Integer partitionId, Map<String, Object> eventParams) {
        Meter partitionEventConsumeMeter = this.eventConsumeMeters.get(partitionId);
        if (partitionEventConsumeMeter == null) {
            partitionEventConsumeMeter = StreamingMetrics.newMeter(MetricRegistry.name("streaming.events.consume.cnt", this.cubeName, String.valueOf(partitionId)));
            this.eventConsumeMeters.put(partitionId, partitionEventConsumeMeter);
        }
        partitionEventConsumeMeter.mark();
    }

    private boolean isFilter(StreamingMessage event) {
        if (this.minAcceptEventTime != 0L && event.getTimestamp() < this.minAcceptEventTime) {
            long countValue = this.dropEventCnt.incrementAndGet();
            if (countValue % 1000L <= 1L) {
                logger.warn("event dropped, event time {}, min event accept time {}", (Object)event.getTimestamp(), (Object)this.minAcceptEventTime);
            }
            return true;
        }
        return event.isFiltered();
    }

    public void stop(long timeoutInMs) {
        this.stopped = true;
        this.waitConsumerStop(timeoutInMs);
    }

    private void waitConsumerStop(long timeoutInMs) {
        try {
            boolean stoppedSucceed = this.stopLatch.await(timeoutInMs, TimeUnit.MILLISECONDS);
            if (stoppedSucceed) {
                return;
            }
            if (!this.hasStoppedConsuming) {
                logger.warn("Consumer not stopped normally, close it forcedly, but the thread may not be stopped correctly");
                this.connector.wakeup();
            }
            if (stoppedSucceed = this.stopLatch.await(timeoutInMs, TimeUnit.MILLISECONDS)) {
                return;
            }
            if (this.hasStoppedConsuming) {
                logger.warn("Consumer has been stopped, but cube data store is not closed");
            } else {
                logger.warn("Consumer is still not stopped");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted!", e);
            Thread.interrupted();
        }
        catch (Exception e) {
            logger.error("Exception throws when wait consumer stopped", e);
        }
    }

    public void pause(boolean wait) {
        this.paused = true;
        if (wait) {
            this.pauseLatch = new CountDownLatch(1);
            try {
                this.pauseLatch.await(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted!", e);
                Thread.interrupted();
            }
        }
    }

    public void resumeToStopCondition(IStopConsumptionCondition newStopCondition) {
        this.paused = false;
        if (newStopCondition != IStopConsumptionCondition.NEVER_STOP) {
            this.setStopCondition(newStopCondition);
            try {
                boolean stoppedSucceed = this.stopLatch.await(120000L, TimeUnit.MILLISECONDS);
                if (!stoppedSucceed) {
                    throw new StreamingException("consumer stop failed for stopCondition:" + newStopCondition);
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted!", e);
            }
        }
    }

    public void resume() {
        this.paused = false;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String getSourceConsumeInfo() {
        return this.cubeSegmentManager.getConsumePositionStr();
    }

    public ConsumerStats getConsumerStats() {
        Map<Integer, Long> consumeLagMap = this.connector.getSource().calConsumeLag(this.cubeName, this.cubeSegmentManager.getConsumePosition());
        long totalLag = 0L;
        HashMap<Integer, PartitionConsumeStats> partitionConsumeStatsMap = Maps.newHashMap();
        for (Map.Entry<Integer, Meter> entry : this.eventConsumeMeters.entrySet()) {
            Meter meter = entry.getValue();
            PartitionConsumeStats stats = new PartitionConsumeStats();
            stats.setAvgRate(meter.getMeanRate());
            stats.setOneMinRate(meter.getOneMinuteRate());
            stats.setFiveMinRate(meter.getFiveMinuteRate());
            stats.setFifteenMinRate(meter.getFifteenMinuteRate());
            stats.setTotalConsume(meter.getCount());
            long thisLag = consumeLagMap.getOrDefault(entry.getKey(), 0L);
            totalLag += thisLag;
            stats.setConsumeLag(thisLag);
            partitionConsumeStatsMap.put(entry.getKey(), stats);
        }
        List<Partition> allPartitions = this.getConsumePartitions();
        for (Partition partition : allPartitions) {
            if (partitionConsumeStatsMap.containsKey(partition.getPartitionId())) continue;
            partitionConsumeStatsMap.put(partition.getPartitionId(), new PartitionConsumeStats());
        }
        ConsumerStats consumerStats = new ConsumerStats();
        consumerStats.setStopped(this.stopped);
        consumerStats.setPaused(this.paused);
        consumerStats.setTotalIncomingEvents(this.incomingEventCnt.get());
        consumerStats.setTotalExceptionEvents(this.parseEventErrorCnt.get() + this.addEventErrorCnt.get());
        consumerStats.setPartitionConsumeStatsMap(partitionConsumeStatsMap);
        consumerStats.setConsumeOffsetInfo(this.getSourceConsumeInfo());
        consumerStats.setConsumeLag(totalLag);
        consumerStats.setConsumerThreadAlive(this.consumerThread.isAlive());
        return consumerStats;
    }

    public IStreamingConnector getConnector() {
        return this.connector;
    }

    public List<Partition> getConsumePartitions() {
        return this.getConnector().getConsumePartitions();
    }
}

