/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.protocol;

import java.util.List;
import java.util.Map;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimDictionaryMetaInfo;

public class FragmentMetaInfo {
    private List<DimDictionaryMetaInfo> dimDictionaryMetaInfos;
    private CuboidMetaInfo basicCuboidMetaInfo;
    private Map<String, CuboidMetaInfo> cuboidMetaInfoMap;
    private long numberOfRows;
    private long originNumOfRows;
    private String fragmentId;
    private long minEventTime;
    private long maxEventTime;
    private int version;

    public List<DimDictionaryMetaInfo> getDimDictionaryMetaInfos() {
        return this.dimDictionaryMetaInfos;
    }

    public void setDimDictionaryMetaInfos(List<DimDictionaryMetaInfo> dimDictionaryMetaInfos) {
        this.dimDictionaryMetaInfos = dimDictionaryMetaInfos;
    }

    public Map<String, CuboidMetaInfo> getCuboidMetaInfoMap() {
        return this.cuboidMetaInfoMap;
    }

    public void setCuboidMetaInfoMap(Map<String, CuboidMetaInfo> cuboidMetaInfoMap) {
        this.cuboidMetaInfoMap = cuboidMetaInfoMap;
    }

    public CuboidMetaInfo getBasicCuboidMetaInfo() {
        return this.basicCuboidMetaInfo;
    }

    public void setBasicCuboidMetaInfo(CuboidMetaInfo basicCuboidMetaInfo) {
        this.basicCuboidMetaInfo = basicCuboidMetaInfo;
    }

    public CuboidMetaInfo getCuboidMetaInfo(long cuboidID) {
        return this.cuboidMetaInfoMap.get(String.valueOf(cuboidID));
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public long getOriginNumOfRows() {
        return this.originNumOfRows;
    }

    public void setOriginNumOfRows(long originNumOfRows) {
        this.originNumOfRows = originNumOfRows;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getMinEventTime() {
        return this.minEventTime;
    }

    public void setMinEventTime(long minEventTime) {
        this.minEventTime = minEventTime;
    }

    public long getMaxEventTime() {
        return this.maxEventTime;
    }

    public void setMaxEventTime(long maxEventTime) {
        this.maxEventTime = maxEventTime;
    }

    public boolean hasValidEventTimeRange() {
        return this.minEventTime != 0L && this.maxEventTime != 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentMetaInfo that = (FragmentMetaInfo)o;
        if (this.numberOfRows != that.numberOfRows) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.dimDictionaryMetaInfos != null ? !this.dimDictionaryMetaInfos.equals(that.dimDictionaryMetaInfos) : that.dimDictionaryMetaInfos != null) {
            return false;
        }
        if (this.basicCuboidMetaInfo != null ? !this.basicCuboidMetaInfo.equals(that.basicCuboidMetaInfo) : that.basicCuboidMetaInfo != null) {
            return false;
        }
        if (this.cuboidMetaInfoMap != null ? !this.cuboidMetaInfoMap.equals(that.cuboidMetaInfoMap) : that.cuboidMetaInfoMap != null) {
            return false;
        }
        return this.fragmentId != null ? this.fragmentId.equals(that.fragmentId) : that.fragmentId == null;
    }

    public int hashCode() {
        int result = this.dimDictionaryMetaInfos != null ? this.dimDictionaryMetaInfos.hashCode() : 0;
        result = 31 * result + (this.basicCuboidMetaInfo != null ? this.basicCuboidMetaInfo.hashCode() : 0);
        result = 31 * result + (this.cuboidMetaInfoMap != null ? this.cuboidMetaInfoMap.hashCode() : 0);
        result = 31 * result + (int)(this.numberOfRows ^ this.numberOfRows >>> 32);
        result = 31 * result + (this.fragmentId != null ? this.fragmentId.hashCode() : 0);
        result = 31 * result + this.version;
        return result;
    }
}

