/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.storage;

import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryBase;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryRequest;
import org.apache.kylin.stream.core.query.StreamingQueryProfile;
import org.apache.kylin.stream.core.storage.StreamingSegmentManager;
import org.apache.kylin.stream.server.StreamingServer;

public class LocalStreamStorageQuery
extends GTCubeStorageQueryBase {
    public LocalStreamStorageQuery(CubeInstance cube) {
        super(cube);
    }

    @Override
    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        StreamingSegmentManager cubeDataStore = StreamingServer.getInstance().getStreamingSegmentManager(this.cubeInstance.getName());
        boolean enableStreamProfile = BackdoorToggles.isStreamingProfileEnable();
        StreamingQueryProfile queryProfile = new StreamingQueryProfile(QueryContextFacade.current().getQueryId(), System.currentTimeMillis());
        if (enableStreamProfile) {
            queryProfile.enableDetailProfile();
        }
        StreamingQueryProfile.set(queryProfile);
        GTCubeStorageQueryRequest request = this.getStorageQueryRequest(context, sqlDigest, returnTupleInfo);
        return cubeDataStore.getSearcher().search(returnTupleInfo, request.getFilter(), request.getHavingFilter(), request.getDimensions(), request.getGroups(), request.getMetrics(), context.isNeedStorageAggregation());
    }

    @Override
    protected String getGTStorage() {
        return null;
    }
}

