/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class PropertySource<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final String name;
    protected final T source;

    public PropertySource(String name, T source) {
        Assert.hasText(name, "Property source name must contain at least one character");
        Assert.notNull(source, "Property source must not be null");
        this.name = name;
        this.source = source;
    }

    public PropertySource(String name) {
        this(name, new Object());
    }

    public String getName() {
        return this.name;
    }

    public T getSource() {
        return this.source;
    }

    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    public abstract Object getProperty(String var1);

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PropertySource && ObjectUtils.nullSafeEquals(this.name, ((PropertySource)obj).name);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.name);
    }

    public String toString() {
        if (this.logger.isDebugEnabled()) {
            return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " {name='" + this.name + "', properties=" + this.source + "}";
        }
        return this.getClass().getSimpleName() + " {name='" + this.name + "'}";
    }

    public static PropertySource<?> named(String name) {
        return new ComparisonPropertySource(name);
    }

    static class ComparisonPropertySource
    extends StubPropertySource {
        private static final String USAGE_ERROR = "ComparisonPropertySource instances are for use with collection comparison only";

        public ComparisonPropertySource(String name) {
            super(name);
        }

        @Override
        public Object getSource() {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        public boolean containsProperty(String name) {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        public String getProperty(String name) {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }
    }

    public static class StubPropertySource
    extends PropertySource<Object> {
        public StubPropertySource(String name) {
            super(name, new Object());
        }

        @Override
        public String getProperty(String name) {
            return null;
        }
    }
}

