/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.util.Assert;

abstract class AbstractExpressionBasedMethodConfigAttribute
implements ConfigAttribute {
    private final Expression filterExpression;
    private final Expression authorizeExpression;

    AbstractExpressionBasedMethodConfigAttribute(String filterExpression, String authorizeExpression) throws ParseException {
        Assert.isTrue(filterExpression != null || authorizeExpression != null, "Filter and authorization Expressions cannot both be null");
        SpelExpressionParser parser = new SpelExpressionParser();
        this.filterExpression = filterExpression == null ? null : parser.parseExpression(filterExpression);
        this.authorizeExpression = authorizeExpression == null ? null : parser.parseExpression(authorizeExpression);
    }

    AbstractExpressionBasedMethodConfigAttribute(Expression filterExpression, Expression authorizeExpression) throws ParseException {
        Assert.isTrue(filterExpression != null || authorizeExpression != null, "Filter and authorization Expressions cannot both be null");
        this.filterExpression = filterExpression == null ? null : filterExpression;
        this.authorizeExpression = authorizeExpression == null ? null : authorizeExpression;
    }

    Expression getFilterExpression() {
        return this.filterExpression;
    }

    Expression getAuthorizeExpression() {
        return this.authorizeExpression;
    }

    @Override
    public String getAttribute() {
        return null;
    }
}

