/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.springframework.core.MethodParameter;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.DeferredResultAdapter;

public class DeferredResultMethodReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    private final Map<Class<?>, DeferredResultAdapter> adapterMap = new HashMap(5);

    public DeferredResultMethodReturnValueHandler() {
        this.adapterMap.put(DeferredResult.class, new SimpleDeferredResultAdapter());
        this.adapterMap.put(ListenableFuture.class, new ListenableFutureAdapter());
        if (ClassUtils.isPresent("java.util.concurrent.CompletionStage", this.getClass().getClassLoader())) {
            this.adapterMap.put(CompletionStage.class, new CompletionStageAdapter());
        }
    }

    @Deprecated
    public Map<Class<?>, DeferredResultAdapter> getAdapterMap() {
        return this.adapterMap;
    }

    private DeferredResultAdapter getAdapterFor(Class<?> type) {
        for (Class<?> adapteeType : this.getAdapterMap().keySet()) {
            if (!adapteeType.isAssignableFrom(type)) continue;
            return this.getAdapterMap().get(adapteeType);
        }
        return null;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getAdapterFor(returnType.getParameterType()) != null;
    }

    @Override
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        return returnValue != null && this.getAdapterFor(returnValue.getClass()) != null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        DeferredResultAdapter adapter = this.getAdapterFor(returnValue.getClass());
        if (adapter == null) {
            throw new IllegalStateException("Could not find DeferredResultAdapter for return value type: " + returnValue.getClass());
        }
        DeferredResult<?> result = adapter.adaptToDeferredResult(returnValue);
        WebAsyncUtils.getAsyncManager(webRequest).startDeferredResultProcessing(result, mavContainer);
    }

    @UsesJava8
    private static class CompletionStageAdapter
    implements DeferredResultAdapter {
        private CompletionStageAdapter() {
        }

        @Override
        public DeferredResult<?> adaptToDeferredResult(Object returnValue) {
            Assert.isInstanceOf(CompletionStage.class, returnValue, "CompletionStage expected");
            final DeferredResult result = new DeferredResult();
            CompletionStage future = (CompletionStage)returnValue;
            future.handle(new BiFunction<Object, Throwable, Object>(){

                @Override
                public Object apply(Object value, Throwable ex) {
                    if (ex != null) {
                        result.setErrorResult(ex);
                    } else {
                        result.setResult(value);
                    }
                    return null;
                }
            });
            return result;
        }
    }

    private static class ListenableFutureAdapter
    implements DeferredResultAdapter {
        private ListenableFutureAdapter() {
        }

        @Override
        public DeferredResult<?> adaptToDeferredResult(Object returnValue) {
            Assert.isInstanceOf(ListenableFuture.class, returnValue, "ListenableFuture expected");
            final DeferredResult result = new DeferredResult();
            ((ListenableFuture)returnValue).addCallback(new ListenableFutureCallback<Object>(){

                @Override
                public void onSuccess(Object value) {
                    result.setResult(value);
                }

                @Override
                public void onFailure(Throwable ex) {
                    result.setErrorResult(ex);
                }
            });
            return result;
        }
    }

    private static class SimpleDeferredResultAdapter
    implements DeferredResultAdapter {
        private SimpleDeferredResultAdapter() {
        }

        @Override
        public DeferredResult<?> adaptToDeferredResult(Object returnValue) {
            Assert.isInstanceOf(DeferredResult.class, returnValue, "DeferredResult expected");
            return (DeferredResult)returnValue;
        }
    }
}

