/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.SplittedBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesSplitter {
    private static final Logger logger = LoggerFactory.getLogger(BytesSplitter.class);
    private static final int[] COMMON_DELIMS = new int[]{"\u007f".codePointAt(0), "|".codePointAt(0), "\t".codePointAt(0), ",".codePointAt(0)};
    private SplittedBytes[] splitBuffers;
    private int bufferSize;

    public SplittedBytes[] getSplitBuffers() {
        return this.splitBuffers;
    }

    public SplittedBytes getSplitBuffer(int index) {
        return this.splitBuffers[index];
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public BytesSplitter(int splitLen, int bytesLen) {
        this.splitBuffers = new SplittedBytes[splitLen];
        for (int i = 0; i < splitLen; ++i) {
            this.splitBuffers[i] = new SplittedBytes(bytesLen);
        }
        this.bufferSize = 0;
    }

    public int split(byte[] bytes, int byteLen, byte delimiter) {
        this.bufferSize = 0;
        int offset = 0;
        int length = 0;
        for (int i = 0; i < byteLen; ++i) {
            if (bytes[i] == delimiter) {
                SplittedBytes split = this.splitBuffers[this.bufferSize++];
                if (length > split.value.length) {
                    length = split.value.length;
                }
                System.arraycopy(bytes, offset, split.value, 0, length);
                split.length = length;
                offset = i + 1;
                length = 0;
                continue;
            }
            ++length;
        }
        SplittedBytes split = this.splitBuffers[this.bufferSize++];
        if (length > split.value.length) {
            length = split.value.length;
        }
        System.arraycopy(bytes, offset, split.value, 0, length);
        split.length = length;
        return this.bufferSize;
    }

    public void setBuffers(byte[][] buffers) {
        for (int i = 0; i < buffers.length; ++i) {
            this.splitBuffers[i].value = buffers[i];
            this.splitBuffers[i].length = buffers[i].length;
        }
        this.bufferSize = buffers.length;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.bufferSize; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Bytes.toString(this.splitBuffers[i].value, 0, this.splitBuffers[i].length));
        }
        return buf.toString();
    }

    public static List<String> splitToString(byte[] bytes, int offset, byte delimiter) {
        ArrayList<String> splitStrings = new ArrayList<String>();
        int splitOffset = 0;
        int splitLength = 0;
        for (int i = offset; i < bytes.length; ++i) {
            if (bytes[i] == delimiter) {
                String str = Bytes.toString(bytes, splitOffset, splitLength);
                splitStrings.add(str);
                splitOffset = i + 1;
                splitLength = 0;
                continue;
            }
            ++splitLength;
        }
        String str = Bytes.toString(bytes, splitOffset, splitLength);
        splitStrings.add(str);
        return splitStrings;
    }
}

