/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SourceConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(SourceConfigurationUtil.class);
    private static final String HIVE_CONF_PREFIX = "hiveconf:";
    public static final String HIVE_CONF_FILENAME = "kylin_hive_conf";
    public static final String SQOOP_CONF_FILENAME = "kylin_sqoop_conf";

    private SourceConfigurationUtil() {
        throw new IllegalStateException("Class SourceConfigurationUtil is an utility class !");
    }

    public static Properties loadHiveJDBCProperties() {
        Map<String, String> hiveConfiguration = SourceConfigurationUtil.loadHiveConfiguration();
        Properties ret = new Properties();
        for (Map.Entry<String, String> entry : hiveConfiguration.entrySet()) {
            ret.put(HIVE_CONF_PREFIX + entry.getKey(), entry.getValue());
        }
        Map<String, String> overrideConf = KylinConfig.getInstanceFromEnv().getHiveConfigOverride();
        for (Map.Entry<String, String> entry : overrideConf.entrySet()) {
            ret.put(HIVE_CONF_PREFIX + entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static Map<String, String> loadHiveConfiguration() {
        return SourceConfigurationUtil.loadXmlConfiguration(HIVE_CONF_FILENAME, true);
    }

    public static Map<String, String> loadSqoopConfiguration() {
        return SourceConfigurationUtil.loadXmlConfiguration(SQOOP_CONF_FILENAME, false);
    }

    private static Map<String, String> loadXmlConfiguration(String filename, boolean checkExist) {
        File confFile;
        HashMap<String, String> confProps = new HashMap<String, String>();
        String xmlFileName = filename + ".xml";
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty(path)) {
            confFile = new File(path, xmlFileName);
        } else {
            path = KylinConfig.getKylinHome();
            if (StringUtils.isEmpty(path)) {
                logger.error("KYLIN_HOME is not set, can not locate conf: {}", (Object)xmlFileName);
                return confProps;
            }
            confFile = new File(path + File.separator + "conf", xmlFileName);
        }
        if (!confFile.exists()) {
            if (checkExist) {
                throw new RuntimeException("Failed to read " + xmlFileName + " at '" + confFile.getAbsolutePath() + "'");
            }
            return confProps;
        }
        String fileUrl = OptionsHelper.convertToFileURL(confFile.getAbsolutePath());
        try {
            File file = new File(fileUrl);
            if (file.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(file);
                NodeList nl = doc.getElementsByTagName("property");
                confProps.clear();
                for (int i = 0; i < nl.getLength(); ++i) {
                    String key = doc.getElementsByTagName("name").item(i).getFirstChild().getNodeValue();
                    String value = doc.getElementsByTagName("value").item(i).getFirstChild().getNodeValue();
                    if (key.equals("tmpjars")) continue;
                    confProps.put(key, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse hive conf file ", e);
        }
        return confProps;
    }
}

