/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import java.util.Locale;
import org.apache.kylin.shaded.com.google.common.base.Strings;

public enum CuboidModeEnum {
    CURRENT("CURRENT"),
    RECOMMEND("RECOMMEND"),
    RECOMMEND_EXISTING("RECOMMEND_EXISTING"),
    RECOMMEND_MISSING("RECOMMEND_MISSING"),
    RECOMMEND_MISSING_WITH_BASE("RECOMMEND_MISSING_WITH_BASE");

    private final String modeName;

    private CuboidModeEnum(String modeName) {
        this.modeName = modeName;
    }

    public String toString() {
        return this.modeName;
    }

    public static CuboidModeEnum getByModeName(String modeName) {
        if (Strings.isNullOrEmpty(modeName)) {
            return null;
        }
        for (CuboidModeEnum mode : CuboidModeEnum.values()) {
            if (!mode.modeName.equals(modeName.toUpperCase(Locale.ROOT))) continue;
            return mode;
        }
        return null;
    }
}

