/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;

public class RowKeyAttrRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        RowKeyDesc row = cube.getRowkey();
        if (row == null) {
            context.addResult(ResultLevel.ERROR, "Rowkey does not exist");
            return;
        }
        RowKeyColDesc[] rcd = row.getRowKeyColumns();
        if (rcd == null || rcd.length == 0) {
            context.addResult(ResultLevel.ERROR, "Rowkey columns do not exist");
            return;
        }
        for (int i = 0; i < rcd.length; ++i) {
            RowKeyColDesc rd = rcd[i];
            if (rd.getColumn() != null && rd.getColumn().length() != 0) continue;
            context.addResult(ResultLevel.ERROR, "Rowkey column empty");
        }
    }
}

