/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CuboidSchedulerUtil;
import org.apache.kylin.engine.mr.steps.CuboidReducer;
import org.apache.kylin.job.execution.ExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CuboidJob.class);
    private Class<? extends Mapper> mapperClass;
    private boolean skipped = false;
    private CuboidScheduler cuboidScheduler;

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    private boolean checkSkip(String cubingJobId, int level) {
        if (cubingJobId == null) {
            return false;
        }
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(cubingJobId);
        boolean bl = this.skipped = !cubingJob.isLayerCubing();
        if (!this.skipped) {
            boolean bl2 = this.skipped = level > this.cuboidScheduler.getBuildLevel();
            if (this.skipped) {
                logger.info("Job level: " + level + " for " + cubingJobId + "[" + cubingJobId + "] exceeds real cuboid tree levels : " + this.cuboidScheduler.getBuildLevel());
            }
        }
        return this.skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (this.mapperClass == null) {
            throw new Exception("Mapper class is not set!");
        }
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_NCUBOID_LEVEL);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_CUBOID_MODE);
            options.addOption(OPTION_DICTIONARY_SHRUNKEN_PATH);
            this.parseOptions(options, args);
            String output = this.getOptionValue(OPTION_OUTPUT_PATH);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            int nCuboidLevel = Integer.parseInt(this.getOptionValue(OPTION_NCUBOID_LEVEL));
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            String cubingJobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            String cuboidModeName = this.getOptionValue(OPTION_CUBOID_MODE);
            if (cuboidModeName == null) {
                cuboidModeName = CuboidModeEnum.CURRENT.toString();
            }
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            this.cuboidScheduler = CuboidSchedulerUtil.getCuboidSchedulerByMode(segment, cuboidModeName);
            if (this.checkSkip(cubingJobId, nCuboidLevel)) {
                logger.info("Skip job " + this.getOptionValue(OPTION_JOB_NAME) + " for " + segmentID + "[" + segmentID + "]");
                int n = 0;
                return n;
            }
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.job.getConfiguration().set("cubingJobId", cubingJobId);
            String shrunkenDictPath = this.getOptionValue(OPTION_DICTIONARY_SHRUNKEN_PATH);
            if (shrunkenDictPath != null) {
                this.job.getConfiguration().set("shrunkenDictPath", shrunkenDictPath);
            }
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.attachSegmentMetadataWithAll(segment, this.job.getConfiguration());
            this.job.setMapperClass(this.mapperClass);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setCombinerClass(CuboidReducer.class);
            this.job.setReducerClass(CuboidReducer.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.getConfiguration().set("dfs.replication", KylinConfig.getInstanceFromEnv().getCuboidDfsReplication());
            this.configureMapperInputFormat(segment);
            IMROutput2.IMROutputFormat outputFormat = MRUtil.getBatchCubingOutputSide2(segment).getOutputFormat();
            outputFormat.configureJobOutput(this.job, output, segment, this.cuboidScheduler, nCuboidLevel);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.getConfiguration().setInt("cube.cuboid.level", nCuboidLevel);
            this.job.getConfiguration().set("cuboid.mode", cuboidModeName);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void configureMapperInputFormat(CubeSegment cubeSeg) throws Exception {
        String input = this.getOptionValue(OPTION_INPUT_PATH);
        if ("FLAT_TABLE".equals(input)) {
            IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(cubeSeg).getFlatTableInputFormat();
            flatTableInputFormat.configureJob(this.job);
        } else {
            IMROutput2.IMROutputFormat outputFormat = MRUtil.getBatchCubingOutputSide2(cubeSeg).getOutputFormat();
            outputFormat.configureJobInput(this.job, input);
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{new Path(input)});
        }
    }

    public void setMapperClass(Class<? extends Mapper> mapperClass) {
        this.mapperClass = mapperClass;
    }
}

