/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CubeGridTable;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.inmemcubing.InputConverterUnitForBaseCuboid;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapperBase;
import org.apache.kylin.engine.mr.steps.MapContextGTRecordWriter;
import org.apache.kylin.gridtable.GTInfo;

public class InMemCuboidFromBaseCuboidMapper
extends InMemCuboidMapperBase<Text, Text, ByteArrayWritable, ByteArrayWritable, ByteArray> {
    private static final Log logger = LogFactory.getLog(InMemCuboidFromBaseCuboidMapper.class);
    private ByteBuffer keyValueBuffer;
    private int keyOffset;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.doSetup(context);
        long baseCuboid = Cuboid.getBaseCuboidId(this.cubeDesc);
        GTInfo gtInfo = CubeGridTable.newGTInfo(Cuboid.findForMandatory(this.cubeDesc, baseCuboid), new CubeDimEncMap(this.cubeDesc, this.dictionaryMap));
        this.keyValueBuffer = ByteBuffer.allocate(gtInfo.getMaxRecordLength());
        this.keyOffset = this.cubeSegment.getRowKeyPreambleSize();
    }

    @Override
    protected InputConverterUnit<ByteArray> getInputConverterUnit(Mapper.Context context) {
        String updateShard = context.getConfiguration().get("update.shard");
        if (updateShard == null || updateShard.equalsIgnoreCase("false")) {
            return new InputConverterUnitForBaseCuboid(false);
        }
        return new InputConverterUnitForBaseCuboid(true);
    }

    @Override
    protected ICuboidWriter getCuboidWriter(Mapper.Context context) {
        return new MapContextGTRecordWriter((MapContext<?, ?, ByteArrayWritable, ByteArrayWritable>)context, this.cubeDesc, this.cubeSegment);
    }

    @Override
    protected ByteArray getRecordFromKeyValue(Text key, Text value) {
        this.keyValueBuffer.clear();
        this.keyValueBuffer.put(key.getBytes(), this.keyOffset, key.getBytes().length - this.keyOffset);
        this.keyValueBuffer.put(value.getBytes());
        byte[] keyValue = new byte[this.keyValueBuffer.position()];
        System.arraycopy(this.keyValueBuffer.array(), 0, keyValue, 0, this.keyValueBuffer.position());
        return new ByteArray(keyValue);
    }
}

