/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.ConvergeCuboidDataUtil;
import org.apache.kylin.engine.mr.steps.UpdateOldCuboidShardMapper;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOldCuboidShardJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(UpdateOldCuboidShardJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            Path input = new Path(this.getOptionValue(OPTION_INPUT_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment optSegment = cube.getSegmentById(segmentID);
            CubeSegment originalSegment = cube.getOriginalSegmentToOptimize(optSegment);
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.job.setMapperClass(UpdateOldCuboidShardMapper.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{input});
            ConvergeCuboidDataUtil.setupReducer(this.job, originalSegment, output);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.attachSegmentsMetadataWithDict(Lists.newArrayList(optSegment, originalSegment), this.job.getConfiguration());
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in CuboidJob", e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }
}

