/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.spark.api.java.function.Function;
import scala.Tuple2;

public class IteratorUtils {
    private IteratorUtils() {
        throw new IllegalStateException("Class IteratorUtils is an utility class !");
    }

    public static <K, V> Iterator<Tuple2<K, V>> merge(final Iterator<Tuple2<K, V>> input, final Comparator<K> comparator, final Function<Iterable<V>, V> converter) {
        return new Iterator<Tuple2<K, V>>(){
            Tuple2<K, V> current;
            {
                this.current = input.hasNext() ? (Tuple2)input.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Tuple2<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                LinkedList<Object> values = new LinkedList<Object>();
                Object currentKey = this.current._1();
                values.add(this.current._2());
                while (input.hasNext()) {
                    Tuple2 next = (Tuple2)input.next();
                    if (comparator.compare(currentKey, next._1()) == 0) {
                        values.add(next._2());
                        continue;
                    }
                    this.current = next;
                    try {
                        return new Tuple2(currentKey, converter.call(values));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!input.hasNext()) {
                    this.current = null;
                }
                try {
                    return new Tuple2(currentKey, converter.call(values));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

