/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kylin.measure.hllc.DenseRegister;
import org.apache.kylin.measure.hllc.Register;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.measure.hllc.SingleValueRegister;

public class SparseRegister
implements Register,
Serializable {
    private Map<Integer, Byte> sparseRegister = new TreeMap<Integer, Byte>();

    public DenseRegister toDense(int p) {
        DenseRegister dr = new DenseRegister(p);
        for (Map.Entry<Integer, Byte> entry : this.sparseRegister.entrySet()) {
            dr.set(entry.getKey(), entry.getValue());
        }
        return dr;
    }

    @Override
    public void set(int pos, byte value) {
        this.sparseRegister.put(pos, value);
    }

    @Override
    public byte get(int pos) {
        Byte b = this.sparseRegister.get(pos);
        return b == null ? (byte)0 : b;
    }

    @Override
    public void merge(Register another) {
        SingleValueRegister sr;
        assert (another.getRegisterType() != RegisterType.DENSE);
        if (another.getRegisterType() == RegisterType.SPARSE) {
            SparseRegister sr2 = (SparseRegister)another;
            for (Map.Entry<Integer, Byte> entry : sr2.sparseRegister.entrySet()) {
                byte v = this.get(entry.getKey());
                if (entry.getValue() <= v) continue;
                this.sparseRegister.put(entry.getKey(), entry.getValue());
            }
        } else if (another.getRegisterType() == RegisterType.SINGLE_VALUE && (sr = (SingleValueRegister)another).getSize() > 0) {
            byte v = this.get(sr.getSingleValuePos());
            if (sr.getValue() > v) {
                this.sparseRegister.put(sr.getSingleValuePos(), sr.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.sparseRegister.clear();
    }

    @Override
    public int getSize() {
        return this.sparseRegister.size();
    }

    @Override
    public RegisterType getRegisterType() {
        return RegisterType.SPARSE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sparseRegister == null ? 0 : this.sparseRegister.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseRegister other = (SparseRegister)obj;
        return !(this.sparseRegister == null ? other.sparseRegister != null : !this.sparseRegister.equals(other.sparseRegister));
    }

    public Collection<Map.Entry<Integer, Byte>> getAllValue() {
        return Collections.unmodifiableCollection(this.sparseRegister.entrySet());
    }
}

