/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.map.bitmap;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMap;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMapFactory;
import org.apache.kylin.measure.map.bitmap.RoaringBitmapCounterMapFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class BitmapMapSerializer
extends DataTypeSerializer<BitmapCounterMap> {
    private static final BitmapCounterMapFactory factory = RoaringBitmapCounterMapFactory.INSTANCE;
    private static final BitmapCounterMap DELEGATE = factory.newBitmapMap();

    public BitmapMapSerializer(DataType type) {
    }

    @Override
    public void serialize(BitmapCounterMap value, ByteBuffer out) {
        if (value == null) {
            value = factory.newBitmapMap();
        }
        try {
            value.write(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BitmapCounterMap deserialize(ByteBuffer in) {
        try {
            return factory.newBitmapMap(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return DELEGATE.peekLength(in);
    }

    @Override
    public int maxLength() {
        return 0x800000;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8192;
    }
}

