/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class Long8Serializer
extends DataTypeSerializer<Long> {
    public Long8Serializer(DataType type) {
    }

    @Override
    public void serialize(Long value, ByteBuffer out) {
        BytesUtil.writeLong(value, out);
    }

    @Override
    public Long deserialize(ByteBuffer in) {
        return BytesUtil.readLong(in);
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 8;
    }

    @Override
    public int maxLength() {
        return 8;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    @Override
    public Long valueOf(String str) {
        return Long.parseLong(str);
    }
}

