/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectL2Cache;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectManager.class);
    public static final Serializer<ProjectInstance> PROJECT_SERIALIZER = new JsonSerializer<ProjectInstance>(ProjectInstance.class);
    private KylinConfig config;
    private ProjectL2Cache l2Cache;
    private CaseInsensitiveStringCache<ProjectInstance> projectMap;
    private CachedCrudAssist<ProjectInstance> crud;
    private AutoReadWriteLock prjMapLock = new AutoReadWriteLock();

    public static ProjectManager getInstance(KylinConfig config) {
        return config.getManager(ProjectManager.class);
    }

    static ProjectManager newInstance(KylinConfig config) throws IOException {
        return new ProjectManager(config);
    }

    private ProjectManager(KylinConfig config) throws IOException {
        logger.info("Initializing ProjectManager with metadata url " + config);
        this.config = config;
        this.projectMap = new CaseInsensitiveStringCache(config, "project");
        this.l2Cache = new ProjectL2Cache(this);
        this.crud = new CachedCrudAssist<ProjectInstance>(this.getStore(), "/project", ProjectInstance.class, this.projectMap){

            @Override
            protected ProjectInstance initEntityAfterReload(ProjectInstance prj, String resourceName) {
                prj.init();
                return prj;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(config).registerListener(new ProjectSyncListener(), "project");
    }

    public void clearL2Cache(String projectname) {
        this.l2Cache.clear(projectname);
    }

    public void reloadProjectL2Cache(String project) {
        this.l2Cache.reloadCacheByProject(project);
    }

    public ProjectInstance reloadProjectQuietly(String project) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            ProjectInstance prj = this.crud.reloadQuietly(project);
            this.clearL2Cache(project);
            ProjectInstance projectInstance = prj;
            return projectInstance;
        }
    }

    public void reloadAll() throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            this.crud.reloadAll();
            this.clearL2Cache(null);
        }
    }

    public List<ProjectInstance> listAllProjects() {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForRead();){
            ArrayList<ProjectInstance> arrayList = new ArrayList<ProjectInstance>(this.projectMap.values());
            return arrayList;
        }
    }

    public ProjectInstance getProject(String projectName) {
        if (projectName == null) {
            return null;
        }
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForRead();){
            ProjectInstance projectInstance = (ProjectInstance)this.projectMap.get(projectName);
            return projectInstance;
        }
    }

    public ProjectInstance getPrjByUuid(String uuid) {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForRead();){
            for (ProjectInstance prj : this.projectMap.values()) {
                if (!uuid.equals(prj.getUuid())) continue;
                ProjectInstance projectInstance = prj;
                return projectInstance;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public ProjectInstance createProject(String projectName, String owner, String description, LinkedHashMap<String, String> overrideProps) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            logger.info("Creating project " + projectName);
            ProjectInstance currentProject = this.getProject(projectName);
            if (currentProject != null) {
                throw new IllegalStateException("The project named " + projectName + "already exists");
            }
            currentProject = ProjectInstance.create(projectName, owner, description, overrideProps, null, null);
            this.checkOverrideProps(currentProject);
            ProjectInstance projectInstance = this.save(currentProject);
            return projectInstance;
        }
    }

    private void checkOverrideProps(ProjectInstance prj) throws IOException {
        LinkedHashMap<String, String> overrideProps = prj.getOverrideKylinProps();
        if (overrideProps != null) {
            for (Map.Entry<String, String> entry : overrideProps.entrySet()) {
                if (!StringUtils.isAnyBlank(entry.getKey(), entry.getValue())) continue;
                throw new IllegalStateException("Property key/value must not be blank");
            }
        }
    }

    public ProjectInstance dropProject(String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            if (projectName == null) {
                throw new IllegalArgumentException("Project name not given");
            }
            ProjectInstance projectInstance = this.getProject(projectName);
            if (projectInstance == null) {
                throw new IllegalStateException("The project named " + projectName + " does not exist");
            }
            if (projectInstance.getRealizationCount(null) != 0) {
                throw new IllegalStateException("The project named " + projectName + " can not be deleted because there's still realizations in it. Delete them first.");
            }
            logger.info("Dropping project '" + projectInstance.getName() + "'");
            this.crud.delete(projectInstance);
            BadQueryHistoryManager.getInstance(this.config).removeBadQueryHistory(projectName);
            this.clearL2Cache(projectName);
            ProjectInstance projectInstance2 = projectInstance;
            return projectInstance2;
        }
    }

    public ProjectInstance updateProject(ProjectInstance project, String newName, String newDesc, LinkedHashMap<String, String> overrideProps) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            Preconditions.checkArgument(project.getName().equals(newName));
            project.setName(newName);
            project.setDescription(newDesc);
            project.setOverrideKylinProps(overrideProps);
            if (project.getUuid() == null) {
                project.updateRandomUuid();
            }
            ProjectInstance projectInstance = this.save(project);
            return projectInstance;
        }
    }

    public ProjectInstance updateProjectOwner(ProjectInstance project, String newOwner) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            project.setOwner(newOwner);
            if (project.getUuid() == null) {
                project.updateRandomUuid();
            }
            ProjectInstance projectInstance = this.save(project);
            return projectInstance;
        }
    }

    public void removeProjectLocal(String proj) {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            this.projectMap.removeLocal(proj);
            this.clearL2Cache(proj);
        }
    }

    public ProjectInstance addModelToProject(String modelName, String newProjectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            this.removeModelFromProjects(modelName);
            ProjectInstance prj = this.getProject(newProjectName);
            if (prj == null) {
                throw new IllegalArgumentException("Project " + newProjectName + " does not exist.");
            }
            prj.addModel(modelName);
            ProjectInstance projectInstance = this.save(prj);
            return projectInstance;
        }
    }

    public void removeModelFromProjects(String modelName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            for (ProjectInstance projectInstance : this.findProjectsByModel(modelName)) {
                projectInstance.removeModel(modelName);
                this.save(projectInstance);
            }
        }
    }

    public ProjectInstance moveRealizationToProject(RealizationType type, String realizationName, String newProjectName, String owner) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            this.removeRealizationsFromProjects(type, realizationName);
            ProjectInstance projectInstance = this.addRealizationToProject(type, realizationName, newProjectName, owner);
            return projectInstance;
        }
    }

    private ProjectInstance addRealizationToProject(RealizationType type, String realizationName, String project, String user) throws IOException {
        if (StringUtils.isEmpty(project)) {
            throw new IllegalArgumentException("Project name should not be empty.");
        }
        ProjectInstance newProject = this.getProject(project);
        if (newProject == null) {
            newProject = this.createProject(project, user, "This is a project automatically added when adding realization " + realizationName + "(" + (Object)((Object)type) + ")", null);
        }
        newProject.addRealizationEntry(type, realizationName);
        this.save(newProject);
        return newProject;
    }

    public void removeRealizationsFromProjects(RealizationType type, String realizationName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            for (ProjectInstance projectInstance : this.findProjects(type, realizationName)) {
                projectInstance.removeRealization(type, realizationName);
                this.save(projectInstance);
            }
        }
    }

    public ProjectInstance addTableDescToProject(String[] tableIdentities, String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            TableMetadataManager metaMgr = this.getTableManager();
            ProjectInstance projectInstance = this.getProject(projectName);
            for (String tableId : tableIdentities) {
                TableDesc table = metaMgr.getTableDesc(tableId, projectName);
                if (table == null) {
                    throw new IllegalStateException("Cannot find table '" + tableId + "' in metadata manager");
                }
                projectInstance.addTable(table.getIdentity());
            }
            ProjectInstance projectInstance2 = this.save(projectInstance);
            return projectInstance2;
        }
    }

    public void removeTableDescFromProject(String tableId, String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            TableMetadataManager metaMgr = this.getTableManager();
            ProjectInstance projectInstance = this.getProject(projectName);
            TableDesc table = metaMgr.getTableDesc(tableId, projectName);
            if (table == null) {
                throw new IllegalStateException("Cannot find table '" + tableId + "' in metadata manager");
            }
            projectInstance.removeTable(table.getIdentity());
            this.save(projectInstance);
        }
    }

    public void removeTableDescFromProject(String[] tableIdentities, String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            TableMetadataManager metaMgr = this.getTableManager();
            ProjectInstance projectInstance = this.getProject(projectName);
            for (String tableId : tableIdentities) {
                TableDesc table = metaMgr.getTableDesc(tableId, projectName);
                if (table == null) {
                    throw new IllegalStateException("Cannot find table '" + tableId + "' in metadata manager");
                }
                projectInstance.removeTable(table.getIdentity());
            }
            this.save(projectInstance);
        }
    }

    public ProjectInstance addExtFilterToProject(String[] filters, String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            TableMetadataManager metaMgr = this.getTableManager();
            ProjectInstance projectInstance = this.getProject(projectName);
            for (String filterName : filters) {
                ExternalFilterDesc extFilter = metaMgr.getExtFilterDesc(filterName);
                if (extFilter == null) {
                    throw new IllegalStateException("Cannot find external filter '" + filterName + "' in metadata manager");
                }
                projectInstance.addExtFilter(filterName);
            }
            ProjectInstance projectInstance2 = this.save(projectInstance);
            return projectInstance2;
        }
    }

    public void removeExtFilterFromProject(String filterName, String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            TableMetadataManager metaMgr = this.getTableManager();
            ProjectInstance projectInstance = this.getProject(projectName);
            ExternalFilterDesc filter = metaMgr.getExtFilterDesc(filterName);
            if (filter == null) {
                throw new IllegalStateException("Cannot find external filter '" + filterName + "' in metadata manager");
            }
            projectInstance.removeExtFilter(filterName);
            this.save(projectInstance);
        }
    }

    public void touchProject(String projectName) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            ProjectInstance projectInstance = this.getProject(projectName);
            this.save(projectInstance);
        }
    }

    private ProjectInstance save(ProjectInstance prj) throws IOException {
        this.crud.save(prj);
        this.clearL2Cache(prj.getName());
        return prj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectInstance getProjectOfModel(String model) {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForRead();){
            Iterator iterator = this.projectMap.values().iterator();
            while (iterator.hasNext()) {
                ProjectInstance prj = (ProjectInstance)iterator.next();
                if (prj.getModels().contains(model)) {
                    ProjectInstance projectInstance = prj;
                    return projectInstance;
                }
            }
            throw new IllegalStateException("No project found for model " + model);
        }
    }

    public List<ProjectInstance> findProjects(RealizationType type, String realizationName) {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            ArrayList<ProjectInstance> result = Lists.newArrayList();
            block9: for (ProjectInstance prj : this.projectMap.values()) {
                for (RealizationEntry entry : prj.getRealizationEntries()) {
                    if (!entry.getType().equals((Object)type) || !entry.getRealization().equals(realizationName)) continue;
                    result.add(prj);
                    continue block9;
                }
            }
            ArrayList<ProjectInstance> arrayList = result;
            return arrayList;
        }
    }

    public List<ProjectInstance> findProjectsByModel(String modelName) {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            ArrayList<ProjectInstance> projects = new ArrayList<ProjectInstance>();
            for (ProjectInstance projectInstance : this.projectMap.values()) {
                if (!projectInstance.containsModel(modelName)) continue;
                projects.add(projectInstance);
            }
            ArrayList<ProjectInstance> arrayList = projects;
            return arrayList;
        }
    }

    public List<ProjectInstance> findProjectsByTable(String tableIdentity) {
        try (AutoReadWriteLock.AutoLock lock = this.prjMapLock.lockForWrite();){
            ArrayList<ProjectInstance> projects = new ArrayList<ProjectInstance>();
            for (ProjectInstance projectInstance : this.projectMap.values()) {
                if (!projectInstance.containsTable(tableIdentity)) continue;
                projects.add(projectInstance);
            }
            ArrayList<ProjectInstance> arrayList = projects;
            return arrayList;
        }
    }

    public Map<String, ExternalFilterDesc> listExternalFilterDescs(String project) {
        return this.l2Cache.listExternalFilterDesc(project);
    }

    public List<TableDesc> listDefinedTables(String project) {
        return this.l2Cache.listDefinedTables(project);
    }

    private Collection<TableDesc> listExposedTablesByRealizations(String project) {
        return this.l2Cache.listExposedTables(project);
    }

    public Collection<TableDesc> listExposedTables(String project, boolean exposeMore) {
        if (exposeMore) {
            return this.listDefinedTables(project);
        }
        return this.listExposedTablesByRealizations(project);
    }

    public List<ColumnDesc> listExposedColumns(String project, TableDesc tableDesc, boolean exposeMore) {
        Set<ColumnDesc> exposedColumns = this.l2Cache.listExposedColumns(project, tableDesc.getIdentity());
        if (exposeMore) {
            HashSet<ColumnDesc> dedup = Sets.newHashSet(tableDesc.getColumns());
            dedup.addAll(exposedColumns);
            return Lists.newArrayList(dedup);
        }
        return Lists.newArrayList(exposedColumns);
    }

    public Set<IRealization> listAllRealizations(String project) {
        return this.l2Cache.listAllRealizations(project);
    }

    public Set<IRealization> getRealizationsByTable(String project, String tableName) {
        return this.l2Cache.getRealizationsByTable(project, tableName.toUpperCase(Locale.ROOT));
    }

    public List<MeasureDesc> listEffectiveRewriteMeasures(String project, String factTable) {
        return this.l2Cache.listEffectiveRewriteMeasures(project, factTable.toUpperCase(Locale.ROOT), true);
    }

    public List<MeasureDesc> listEffectiveMeasures(String project, String factTable) {
        return this.l2Cache.listEffectiveRewriteMeasures(project, factTable.toUpperCase(Locale.ROOT), false);
    }

    KylinConfig getConfig() {
        return this.config;
    }

    ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    TableMetadataManager getTableManager() {
        return TableMetadataManager.getInstance(this.config);
    }

    private class ProjectSyncListener
    extends Broadcaster.Listener {
        private ProjectSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String project = cacheKey;
            if (event == Broadcaster.Event.DROP) {
                ProjectManager.this.removeProjectLocal(project);
                return;
            }
            ProjectManager.this.reloadProjectQuietly(project);
            broadcaster.notifyProjectSchemaUpdate(project);
            broadcaster.notifyProjectDataUpdate(project);
        }
    }
}

