/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib;

import java.io.Closeable;
import java.util.regex.Pattern;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.base.Strings;

public abstract class ActiveReservoirReporter
implements Closeable {
    public static final String KYLIN_PREFIX = KylinConfig.getInstanceFromEnv().getKylinMetricsPrefix();

    public static Pair<String, String> getTableNameSplits(String tableName) {
        if (Strings.isNullOrEmpty(tableName)) {
            return null;
        }
        String[] splits = tableName.split(Pattern.quote("."));
        int i = 0;
        String database = splits.length == 1 ? KYLIN_PREFIX : splits[i++];
        String tableNameOnly = splits[i];
        return new Pair<String, String>(database, tableNameOnly);
    }

    public static String getTableName(Pair<String, String> tableNameSplits) {
        return tableNameSplits.getFirst() + "." + tableNameSplits.getSecond();
    }

    public abstract void start();

    public abstract void stop();
}

