/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScheduledReporter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(BaseScheduledReporter.class);
    private final ScheduledExecutorService executor;

    BaseScheduledReporter() {
        this("default");
    }

    BaseScheduledReporter(String name) {
        this(Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("metrics-scheduler-" + name + "-%d").build()));
    }

    BaseScheduledReporter(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public abstract void report();

    public void start(long period, TimeUnit unit) {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseScheduledReporter.this.report();
                }
                catch (RuntimeException ex) {
                    logger.error("RuntimeException thrown from {}#report. Exception was suppressed.", (Object)BaseScheduledReporter.this.getClass().getSimpleName(), (Object)ex);
                }
            }
        }, period, period, unit);
    }

    public void stop() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    System.err.println(this.getClass().getSimpleName() + ": ScheduledExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

