/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.init;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.rest.init.InitialTask;
import org.apache.kylin.rest.metrics.QueryMetrics2Facade;
import org.apache.kylin.rest.metrics.QueryMetricsFacade;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InitialTaskManager
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(InitialTaskManager.class);

    public void afterPropertiesSet() throws Exception {
        logger.info("Kylin service is starting.....");
        this.runInitialTasks();
    }

    private void runInitialTasks() {
        QueryMetricsFacade.init();
        QueryMetrics2Facade.init();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String initTasks = kylinConfig.getInitTasks();
        if (!StringUtils.isEmpty(initTasks)) {
            String[] taskClasses;
            for (String taskClass : taskClasses = StringUtil.splitByComma(initTasks)) {
                try {
                    InitialTask task = (InitialTask)Class.forName(taskClass).newInstance();
                    logger.info("Running initial task: " + taskClass);
                    task.execute();
                }
                catch (Throwable e) {
                    logger.error("Initial task failed: " + taskClass, e);
                }
            }
            logger.info("All initial tasks finished.");
        }
    }
}

