/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.StreamingMessageRow;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingParser {
    private static final Logger logger = LoggerFactory.getLogger(StreamingParser.class);
    public static final String PROPERTY_TS_COLUMN_NAME = "tsColName";
    public static final String PROPERTY_TS_PARSER = "tsParser";
    public static final String PROPERTY_TS_PATTERN = "tsPattern";
    public static final String PROPERTY_EMBEDDED_SEPARATOR = "separator";
    public static final String PROPERTY_STRICT_CHECK = "strictCheck";
    public static final Map<String, String> defaultProperties = Maps.newHashMap();
    public static final Map<String, Integer> derivedTimeColumns = Maps.newHashMap();

    public abstract List<StreamingMessageRow> parse(ByteBuffer var1);

    public abstract boolean filter(StreamingMessageRow var1);

    public static StreamingParser getStreamingParser(String parserName, String parserProperties, List<TblColRef> columns) throws ReflectiveOperationException {
        if (!StringUtils.isEmpty(parserName)) {
            logger.info("Construct StreamingParse {} with properties {}", (Object)parserName, (Object)parserProperties);
            Class<?> clazz = Class.forName(parserName);
            Map<String, String> properties = StreamingParser.parseProperties(parserProperties);
            Constructor<?> constructor = clazz.getConstructor(List.class, Map.class);
            return (StreamingParser)constructor.newInstance(columns, properties);
        }
        throw new IllegalStateException("Invalid StreamingConfig, parserName " + parserName + ", parserProperties " + parserProperties + ".");
    }

    public static Map<String, String> parseProperties(String propertiesStr) {
        HashMap<String, String> result = Maps.newHashMap(defaultProperties);
        if (!StringUtils.isEmpty(propertiesStr)) {
            String[] properties;
            for (String prop : properties = propertiesStr.split(";")) {
                String[] parts = prop.split("=");
                if (parts.length == 2) {
                    result.put(parts[0], parts[1]);
                    continue;
                }
                logger.warn("Ignored invalid property expression '" + prop + "'");
            }
        }
        return result;
    }

    public static final boolean populateDerivedTimeColumns(String columnName, List<String> result, long t) {
        String timeZoneStr = KylinConfig.getInstanceFromEnv().getTimeZone();
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
        Integer derivedTimeColumn = derivedTimeColumns.get(columnName);
        if (derivedTimeColumn == null) {
            return false;
        }
        long normalized = 0L;
        switch (derivedTimeColumn) {
            case 1: {
                normalized = TimeUtil.getMinuteStart(t);
                result.add(DateFormat.formatToTimeStrWithTimeZone(timeZone, normalized));
                break;
            }
            case 2: {
                normalized = TimeUtil.getHourStart(t);
                result.add(DateFormat.formatToTimeStrWithTimeZone(timeZone, normalized));
                break;
            }
            case 3: {
                normalized = TimeUtil.getDayStartWithTimeZone(timeZone, t);
                result.add(DateFormat.formatToDateStrWithTimeZone(timeZone, normalized));
                break;
            }
            case 4: {
                normalized = TimeUtil.getWeekStartWithTimeZone(timeZone, t);
                result.add(DateFormat.formatToDateStrWithTimeZone(timeZone, normalized));
                break;
            }
            case 5: {
                normalized = TimeUtil.getMonthStartWithTimeZone(timeZone, t);
                result.add(DateFormat.formatToDateStrWithTimeZone(timeZone, normalized));
                break;
            }
            case 6: {
                normalized = TimeUtil.getQuarterStartWithTimeZone(timeZone, t);
                result.add(DateFormat.formatToDateStrWithTimeZone(timeZone, normalized));
                break;
            }
            case 7: {
                normalized = TimeUtil.getYearStartWithTimeZone(timeZone, t);
                result.add(DateFormat.formatToDateStrWithTimeZone(timeZone, normalized));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    static {
        derivedTimeColumns.put("minute_start", 1);
        derivedTimeColumns.put("hour_start", 2);
        derivedTimeColumns.put("day_start", 3);
        derivedTimeColumns.put("week_start", 4);
        derivedTimeColumns.put("month_start", 5);
        derivedTimeColumns.put("quarter_start", 6);
        derivedTimeColumns.put("year_start", 7);
        defaultProperties.put(PROPERTY_TS_COLUMN_NAME, "timestamp");
        defaultProperties.put(PROPERTY_TS_PARSER, "org.apache.kylin.source.kafka.DefaultTimeParser");
        defaultProperties.put(PROPERTY_TS_PATTERN, "yyyy-MM-dd HH:mm:ss");
        defaultProperties.put(PROPERTY_EMBEDDED_SEPARATOR, "_");
        defaultProperties.put(PROPERTY_STRICT_CHECK, "false");
    }
}

