/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class KafkaInputSplit
extends InputSplit
implements Writable {
    private String brokers;
    private String topic;
    private int partition;
    private long offsetStart;
    private long offsetEnd;

    public KafkaInputSplit() {
    }

    public KafkaInputSplit(String brokers, String topic, int partition, long offsetStart, long offsetEnd) {
        this.brokers = brokers;
        this.topic = topic;
        this.partition = partition;
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
    }

    public void readFields(DataInput in) throws IOException {
        this.brokers = Text.readString((DataInput)in);
        this.topic = Text.readString((DataInput)in);
        this.partition = in.readInt();
        this.offsetStart = in.readLong();
        this.offsetEnd = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.brokers);
        Text.writeString((DataOutput)out, (String)this.topic);
        out.writeInt(this.partition);
        out.writeLong(this.offsetStart);
        out.writeLong(this.offsetEnd);
    }

    public long getLength() throws IOException, InterruptedException {
        return Long.MAX_VALUE;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[]{this.brokers};
    }

    public int getPartition() {
        return this.partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getBrokers() {
        return this.brokers;
    }

    public long getOffsetStart() {
        return this.offsetStart;
    }

    public long getOffsetEnd() {
        return this.offsetEnd;
    }

    public String toString() {
        return this.brokers + "-" + this.topic + "-" + this.partition + "-" + this.offsetStart + "-" + this.offsetEnd;
    }
}

