/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;

public class ColumnarRecordCodec {
    private DimensionEncoding[] dimEncodings;
    private DataTypeSerializer[] dimSerializers;
    private DataTypeSerializer[] metricsSerializers;

    public ColumnarRecordCodec(DimensionEncoding[] dimEncodings, ColumnarMetricsEncoding[] metricsEncodings) {
        int i;
        this.dimEncodings = dimEncodings;
        this.dimSerializers = new DataTypeSerializer[dimEncodings.length];
        for (i = 0; i < dimEncodings.length; ++i) {
            this.dimSerializers[i] = dimEncodings[i].asDataTypeSerializer();
        }
        this.metricsSerializers = new DataTypeSerializer[metricsEncodings.length];
        for (i = 0; i < metricsEncodings.length; ++i) {
            this.metricsSerializers[i] = metricsEncodings[i].asDataTypeSerializer();
        }
    }

    public Object decodeMetrics(int i, byte[] metricsVal) {
        return this.metricsSerializers[i].deserialize(ByteBuffer.wrap(metricsVal));
    }

    public String decodeDimension(int i, byte[] dimVal) {
        return this.dimEncodings[i].decode(dimVal, 0, dimVal.length);
    }

    public void encodeDimension(int col, Object value, int roundingFlag, ByteBuffer buf) {
        DataTypeSerializer<Object> serializer = this.dimSerializers[col];
        if (serializer instanceof DictionaryDimEnc.DictionarySerializer) {
            DictionaryDimEnc dictEnc = (DictionaryDimEnc)this.dimEncodings[col];
            if (dictEnc.getRoundingFlag() != roundingFlag) {
                serializer = dictEnc.copy(roundingFlag).asDataTypeSerializer();
            }
            try {
                serializer.serialize(value, buf);
            }
            catch (IllegalArgumentException ex) {
                IllegalArgumentException rewordEx = new IllegalArgumentException("Column " + col + " value '" + this.toStringBinary(value) + "' met dictionary error: " + ex.getMessage());
                rewordEx.setStackTrace(ex.getStackTrace());
                throw rewordEx;
            }
        } else {
            if (value instanceof String) {
                value = serializer.valueOf((String)value);
            }
            serializer.serialize(value, buf);
        }
    }

    public int getMaxDimLength() {
        int max = 0;
        for (int i = 0; i < this.dimSerializers.length; ++i) {
            max = Math.max(max, this.dimSerializers[i].maxLength());
        }
        return max;
    }

    public int getMaxMetricsLength() {
        int max = 0;
        for (int i = 0; i < this.metricsSerializers.length; ++i) {
            max = Math.max(max, this.metricsSerializers[i].maxLength());
        }
        return max;
    }

    public DimensionEncoding[] getDimensionEncodings() {
        return this.dimEncodings;
    }

    private String toStringBinary(Object value) {
        if (value == null) {
            return "Null";
        }
        byte[] bytes = value.toString().getBytes(Charset.forName("UTF-8"));
        return Bytes.toStringBinary(bytes);
    }
}

