/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.File;
import java.io.IOException;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.stream.core.exception.IllegalStorageException;
import org.apache.kylin.stream.core.exception.StreamingException;
import org.apache.kylin.stream.core.storage.columnar.FragmentId;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSegmentFragment
implements Comparable<DataSegmentFragment> {
    private static Logger logger = LoggerFactory.getLogger(DataSegmentFragment.class);
    private String baseStorePath;
    private String cubeName;
    private String segmentName;
    private FragmentId fragmentId;

    public DataSegmentFragment(String baseStorePath, String cubeName, String segmentName, FragmentId fragmentId) {
        this.baseStorePath = baseStorePath;
        this.cubeName = cubeName;
        this.segmentName = segmentName;
        this.fragmentId = fragmentId;
        this.createIfNotExist();
    }

    public void createIfNotExist() {
        File fragmentFolder = this.getFragmentFolder();
        if (!fragmentFolder.exists()) {
            fragmentFolder.mkdirs();
        }
    }

    public FragmentId getFragmentId() {
        return this.fragmentId;
    }

    public boolean isMergedFragment() {
        return this.fragmentId.getEndId() != this.fragmentId.getStartId();
    }

    public void purge() {
        File fragmentFolder = this.getFragmentFolder();
        try {
            FileUtils.deleteDirectory(fragmentFolder);
        }
        catch (IOException e) {
            logger.error("error happens when purge fragment", e);
        }
    }

    public File getDataFile() {
        File parentFolder = this.getFragmentFolder();
        File dataFile = new File(parentFolder, this.fragmentId + ".data");
        if (!dataFile.exists()) {
            try {
                dataFile.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStorageException(e);
            }
        }
        return dataFile;
    }

    public long getDataFileSize() {
        return this.getDataFile().length();
    }

    public File getFragmentFolder() {
        return new File(this.baseStorePath + File.separator + this.cubeName + File.separator + this.segmentName + File.separator + this.fragmentId.toString());
    }

    public File getMetaFile() {
        File parentFolder = this.getFragmentFolder();
        File metaFile = new File(parentFolder, this.fragmentId + ".meta");
        return metaFile;
    }

    public FragmentMetaInfo getMetaInfo() {
        File metaFile = this.getMetaFile();
        if (metaFile == null || !metaFile.exists()) {
            return null;
        }
        try {
            return JsonUtil.readValue(metaFile, FragmentMetaInfo.class);
        }
        catch (IOException e) {
            throw new StreamingException("error when parse meta file");
        }
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSegmentFragment that = (DataSegmentFragment)o;
        if (this.cubeName != null ? !this.cubeName.equals(that.cubeName) : that.cubeName != null) {
            return false;
        }
        if (this.segmentName != null ? !this.segmentName.equals(that.segmentName) : that.segmentName != null) {
            return false;
        }
        return this.fragmentId != null ? this.fragmentId.equals(that.fragmentId) : that.fragmentId == null;
    }

    public int hashCode() {
        int result = this.cubeName != null ? this.cubeName.hashCode() : 0;
        result = 31 * result + (this.segmentName != null ? this.segmentName.hashCode() : 0);
        result = 31 * result + (this.fragmentId != null ? this.fragmentId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{cubeName='" + this.cubeName + '\'' + ", segmentName='" + this.segmentName + '\'' + ", fragmentId=" + this.fragmentId + '}';
    }

    @Override
    public int compareTo(DataSegmentFragment o) {
        if (!this.cubeName.equals(o.cubeName)) {
            return this.cubeName.compareTo(o.cubeName);
        }
        if (!this.segmentName.equals(o.segmentName)) {
            return this.segmentName.compareTo(o.segmentName);
        }
        return this.fragmentId.compareTo(o.fragmentId);
    }
}

