/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;

public class FSInputRLECompressedColumnReader
implements ColumnDataReader {
    private int valLen;
    private int numValInBlock;
    private ByteBuffer currBlockBuffer;
    private int currBlockNum;
    private FSDataInputStream fsInputStream;
    private int rowCount;

    public FSInputRLECompressedColumnReader(FileSystem fs, Path file, int columnDataStartOffset, int columnDataLength, int rowCount) throws IOException {
        this.rowCount = rowCount;
        this.fsInputStream = fs.open(file);
        int footStartOffset = columnDataStartOffset + columnDataLength - 8;
        this.fsInputStream.seek((long)footStartOffset);
        this.numValInBlock = this.fsInputStream.readInt();
        this.valLen = this.fsInputStream.readInt();
        this.fsInputStream.seek((long)columnDataStartOffset);
        this.currBlockNum = -1;
    }

    public void reset() {
        this.currBlockNum = -1;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new RunLengthCompressedColumnDataItr();
    }

    @Override
    public byte[] read(int rowNum) {
        throw new UnsupportedOperationException("not support to read row operation");
    }

    @Override
    public void close() throws IOException {
        this.fsInputStream.close();
    }

    private class RunLengthCompressedColumnDataItr
    implements Iterator<byte[]> {
        private int currRLEntryValCnt;
        private byte[] currRLEntryVal;
        private int readRLEntryValCnt;
        private int readRowCount = 0;
        private int blockReadRowCount = 0;

        public RunLengthCompressedColumnDataItr() {
            this.currRLEntryVal = new byte[FSInputRLECompressedColumnReader.this.valLen];
        }

        @Override
        public boolean hasNext() {
            return this.readRowCount < FSInputRLECompressedColumnReader.this.rowCount;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.readRLEntryValCnt >= this.currRLEntryValCnt) {
                this.loadNextEntry();
            }
            ++this.readRLEntryValCnt;
            ++this.readRowCount;
            ++this.blockReadRowCount;
            return this.currRLEntryVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported");
        }

        private void loadNextEntry() {
            if (FSInputRLECompressedColumnReader.this.currBlockNum == -1 || this.blockReadRowCount >= FSInputRLECompressedColumnReader.this.numValInBlock) {
                try {
                    this.loadNextBuffer();
                }
                catch (IOException e) {
                    throw new RuntimeException("error when read data", e);
                }
                this.currRLEntryVal = new byte[FSInputRLECompressedColumnReader.this.valLen];
                this.blockReadRowCount = 0;
            }
            this.currRLEntryValCnt = FSInputRLECompressedColumnReader.this.currBlockBuffer.getInt();
            FSInputRLECompressedColumnReader.this.currBlockBuffer.get(this.currRLEntryVal);
            this.readRLEntryValCnt = 0;
        }

        private void loadNextBuffer() throws IOException {
            int len = FSInputRLECompressedColumnReader.this.fsInputStream.readInt();
            byte[] bytes = new byte[len];
            FSInputRLECompressedColumnReader.this.fsInputStream.readFully(bytes);
            FSInputRLECompressedColumnReader.this.currBlockBuffer = ByteBuffer.wrap(bytes);
            FSInputRLECompressedColumnReader.this.currBlockNum++;
        }
    }
}

