/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.invertindex;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dimension.DimensionEncoding;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class ColInvertIndexSearcher {
    private ByteBuffer bitmapBuffer;
    private int bitmapStartOffset;
    private IOffsetDictionary offsetDictionary;

    public static ColInvertIndexSearcher load(ByteBuffer buffer) throws IOException {
        ColInvertIndexSearcher result = new ColInvertIndexSearcher();
        result.bitmapStartOffset = buffer.position();
        int type = buffer.getInt(buffer.limit() - 4);
        result.offsetDictionary = type == 0 ? new SeqOffsetDictionary(buffer) : new SortValueOffsetDictionary(buffer);
        result.bitmapBuffer = buffer;
        return result;
    }

    public ImmutableRoaringBitmap searchValue(byte[] value) {
        int offset = this.offsetDictionary.getBitMapOffset(value);
        if (offset == -1) {
            return null;
        }
        ByteBuffer usedBuffer = this.bitmapBuffer.asReadOnlyBuffer();
        usedBuffer.position(this.bitmapStartOffset + offset);
        ImmutableRoaringBitmap bitmap = new ImmutableRoaringBitmap(usedBuffer);
        return bitmap;
    }

    public static class SortValueOffsetDictionary
    implements IOffsetDictionary {
        private int valueLen;
        private ByteBuffer offsetBuffer;
        private int cardinality;
        private int dictStartOffset;

        SortValueOffsetDictionary(ByteBuffer byteBuffer) {
            this.offsetBuffer = byteBuffer;
            byteBuffer.position(byteBuffer.limit() - 12);
            this.cardinality = byteBuffer.getInt();
            this.valueLen = byteBuffer.getInt();
            this.dictStartOffset = byteBuffer.limit() - 12 - this.cardinality * (this.valueLen + 4);
        }

        @Override
        public int getBitMapOffset(byte[] value) {
            if (value == null) {
                value = this.getNullValue();
            }
            return this.binarySearch(value);
        }

        private int binarySearch(byte[] value) {
            int low = 0;
            int high = this.cardinality - 1;
            byte[] currVal = new byte[this.valueLen];
            while (low <= high) {
                int mid = low + high >>> 1;
                this.offsetBuffer.position(this.dictStartOffset + mid * (this.valueLen + 4));
                this.offsetBuffer.get(currVal);
                int cmp = Bytes.compareTo(value, currVal);
                if (cmp == 0) {
                    return this.offsetBuffer.getInt();
                }
                if (cmp < 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return -1;
        }

        private byte[] getNullValue() {
            byte[] result = new byte[this.valueLen];
            for (int i = 0; i < this.valueLen; ++i) {
                result[i] = -1;
            }
            return result;
        }
    }

    public static class SeqOffsetDictionary
    implements IOffsetDictionary {
        private int minVal;
        private int maxVal;
        private boolean hasNullVal = false;
        private ByteBuffer offsetBuffer;
        private int dictStartOffset;
        private int cardinality;

        SeqOffsetDictionary(ByteBuffer byteBuffer) {
            this.offsetBuffer = byteBuffer;
            byteBuffer.position(byteBuffer.limit() - 17);
            this.cardinality = byteBuffer.getInt();
            this.minVal = byteBuffer.getInt();
            this.maxVal = byteBuffer.getInt();
            this.dictStartOffset = byteBuffer.limit() - 17 - (this.cardinality << 2);
            byte nullByte = byteBuffer.get();
            if (nullByte != 0) {
                this.hasNullVal = true;
            }
        }

        @Override
        public int getBitMapOffset(byte[] value) {
            if (value == null || DimensionEncoding.isNull(value, 0, value.length)) {
                if (!this.hasNullVal) {
                    return -1;
                }
                return this.offsetBuffer.getInt(this.dictStartOffset + (this.cardinality - 1 << 2));
            }
            int intVal = Bytes.readAsInt(value, 0, value.length);
            if (intVal < this.minVal || intVal > this.maxVal) {
                return -1;
            }
            int idx = intVal - this.minVal;
            return this.offsetBuffer.getInt(this.dictStartOffset + (idx << 2));
        }
    }

    public static interface IOffsetDictionary {
        public int getBitMapOffset(byte[] var1);
    }
}

