/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.source.kafka;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.exception.StreamingException;
import org.apache.kylin.stream.core.model.StreamingMessage;
import org.apache.kylin.stream.core.source.IStreamingMessageParser;
import org.apache.kylin.stream.core.source.MessageParserInfo;
import org.apache.kylin.stream.source.kafka.AbstractTimeParser;
import org.apache.kylin.stream.source.kafka.KafkaPosition;
import org.apache.kylin.stream.source.kafka.LongTimeParser;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.type.MapType;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.type.SimpleType;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimedJsonStreamParser
implements IStreamingMessageParser<ConsumerRecord<byte[], byte[]>> {
    private static final Logger logger = LoggerFactory.getLogger(TimedJsonStreamParser.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final JavaType mapType = MapType.construct(HashMap.class, SimpleType.construct(String.class), SimpleType.construct(Object.class));
    private List<TblColRef> allColumns;
    private boolean formatTs = false;
    private String tsColName = "timestamp";
    private String tsParser = null;
    private AbstractTimeParser streamTimeParser;
    private long timeZoneOffset = 0L;
    private Map<String, String[]> columnToSourceFieldMapping = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> root = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> tmp = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public TimedJsonStreamParser(CubeDesc cubeDesc, MessageParserInfo parserInfo) {
        this(new CubeJoinedFlatTableDesc(cubeDesc).getAllColumns(), parserInfo);
        String timeZone = cubeDesc.getConfig().getStreamingDerivedTimeTimezone();
        if (timeZone.length() > 0) {
            this.timeZoneOffset = TimeZone.getTimeZone(timeZone).getRawOffset();
        }
    }

    public TimedJsonStreamParser(List<TblColRef> cols, MessageParserInfo parserInfo) {
        this.allColumns = cols;
        if (parserInfo != null) {
            this.formatTs = parserInfo.isFormatTs();
            this.tsColName = parserInfo.getTsColName();
            Map<String, String> mapping = parserInfo.getColumnToSourceFieldMapping();
            if (mapping != null && !mapping.isEmpty()) {
                for (String col : mapping.keySet()) {
                    if ((mapping.get(col) == null || !mapping.get(col).contains(".")) && col.equals(mapping.get(col))) continue;
                    this.columnToSourceFieldMapping.put(col, mapping.get(col).split("\\."));
                }
                logger.info("Using parser field mapping by {}", (Object)parserInfo.getColumnToSourceFieldMapping());
            }
            this.tsParser = parserInfo.getTsParser();
            if (!StringUtils.isEmpty(this.tsParser)) {
                try {
                    Class<?> clazz = Class.forName(this.tsParser);
                    Constructor<?> constructor = clazz.getConstructor(MessageParserInfo.class);
                    this.streamTimeParser = (AbstractTimeParser)constructor.newInstance(parserInfo);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Invalid StreamingConfig, tsParser " + this.tsParser + ", tsPattern " + parserInfo.getTsPattern() + ".", e);
                }
            } else {
                parserInfo.setTsParser("org.apache.kylin.stream.source.kafka.LongTimeParser");
                parserInfo.setTsPattern("MS");
                this.streamTimeParser = new LongTimeParser(parserInfo);
            }
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        this.mapper.enable(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY);
        logger.info("TimedJsonStreamParser with formatTs {} tsColName {}", (Object)this.formatTs, (Object)this.tsColName);
    }

    public static String objToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return String.valueOf(Arrays.asList((Object[])value));
        }
        return String.valueOf(value);
    }

    @Override
    public StreamingMessage parse(ConsumerRecord<byte[], byte[]> record) {
        try {
            Map message = (Map)this.mapper.readValue(this.parseToString((byte[])record.value()), this.mapType);
            this.root.clear();
            this.root.putAll(message);
            String tsStr = this.root.get(this.tsColName).toString();
            long t = StringUtils.isEmpty(tsStr) ? 0L : this.streamTimeParser.parseTime(tsStr);
            ArrayList<String> result = Lists.newArrayList();
            for (TblColRef column : this.allColumns) {
                String columnName = column.getName();
                TimeDerivedColumnType columnType = TimeDerivedColumnType.getTimeDerivedColumnType(columnName);
                if (columnType != null) {
                    if (TimeDerivedColumnType.isTimeDerivedColumnAboveDayLevel(columnName)) {
                        result.add(String.valueOf(columnType.normalize(t + this.timeZoneOffset)));
                        continue;
                    }
                    result.add(String.valueOf(columnType.normalize(t)));
                    continue;
                }
                Object value = this.root.get(columnName.toLowerCase(Locale.ROOT));
                if (value == null) {
                    String[] pathToValue = this.columnToSourceFieldMapping.get(columnName);
                    if (pathToValue != null) {
                        result.add(this.processMultiLevelJson(pathToValue, this.root));
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                result.add(value.toString());
            }
            return new StreamingMessage(result, new KafkaPosition.KafkaPartitionPosition(record.partition(), record.offset()), t, Collections.emptyMap());
        }
        catch (IOException e) {
            logger.error("error", e);
            throw new RuntimeException(e);
        }
    }

    private String parseToString(byte[] bytes) {
        String value;
        try {
            value = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamingException(e);
        }
        return value;
    }

    private String processMultiLevelJson(String[] path, Map map) {
        String key;
        Object value = null;
        String[] stringArray = path;
        int n = stringArray.length;
        for (int i = 0; i < n && (value = map.get(key = stringArray[i])) instanceof Map; ++i) {
            this.tmp.clear();
            this.tmp.putAll(value);
            map = this.tmp;
        }
        return TimedJsonStreamParser.objToString(value);
    }
}

