/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseUsageExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(HBaseUsageExtractor.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_PROJECT;
    public static final String HDFS_CHECK_COMMAND = "hadoop fs -ls -R %s/data/%s/%s*";
    private final String hbaseRootDir;
    private final String cachedHMasterUrl;
    private List<String> htables = Lists.newArrayList();
    private Configuration conf;
    private CubeManager cubeManager;
    private RealizationRegistry realizationRegistry;
    private KylinConfig kylinConfig;
    private ProjectManager projectManager;

    public HBaseUsageExtractor() {
        this.packageType = "hbase";
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.setRequired(true);
        this.options.addOptionGroup(realizationOrProject);
        this.conf = HBaseConfiguration.create();
        this.hbaseRootDir = this.conf.get("hbase.rootdir");
        this.cachedHMasterUrl = this.getHBaseMasterUrl();
    }

    public static void main(String[] args) {
        HBaseUsageExtractor extractor = new HBaseUsageExtractor();
        extractor.execute(args);
    }

    private String getHBaseMasterUrl() {
        String host = this.conf.get("hbase.master.info.bindAddress");
        if (host.equals("0.0.0.0")) {
            try {
                host = MasterAddressTracker.getMasterAddress((ZooKeeperWatcher)new ZooKeeperWatcher(this.conf, null, null)).getHostname();
            }
            catch (IOException | KeeperException io) {
                return null;
            }
        }
        String port = this.conf.get("hbase.master.info.port");
        return "http://" + host + ":" + port + "/";
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        if (this.cachedHMasterUrl == null) {
            return;
        }
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cubeManager = CubeManager.getInstance(this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance(this.kylinConfig);
        this.projectManager = ProjectManager.getInstance(this.kylinConfig);
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String projectNames = optionsHelper.getOptionValue(OPTION_PROJECT);
            for (String projectName : StringUtil.splitByComma(projectNames)) {
                ProjectInstance projectInstance = this.projectManager.getProject(projectName);
                if (projectInstance == null) {
                    throw new IllegalArgumentException("Project " + projectName + " does not exist");
                }
                List<RealizationEntry> realizationEntries = projectInstance.getRealizationEntries();
                for (RealizationEntry realizationEntry : realizationEntries) {
                    this.retrieveResourcePath(this.getRealization(realizationEntry));
                }
            }
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeNames = optionsHelper.getOptionValue(OPTION_CUBE);
            for (String cubeName : StringUtil.splitByComma(cubeNames)) {
                IRealization realization = this.cubeManager.getRealization(cubeName);
                if (realization == null) {
                    throw new IllegalArgumentException("No cube found with name of " + cubeName);
                }
                this.retrieveResourcePath(realization);
            }
        }
        this.extractCommonInfo(exportDir, this.kylinConfig);
        this.extractHTables(exportDir);
    }

    private void extractHTables(File dest) throws IOException {
        logger.info("These htables are going to be extracted:");
        for (String htable : this.htables) {
            logger.info("{} is required", (Object)htable);
        }
        File tableDir = new File(dest, "table");
        FileUtils.forceMkdir(tableDir);
        for (String htable : this.htables) {
            try {
                URL srcUrl = new URL(this.cachedHMasterUrl + "table.jsp?name=" + htable);
                File destFile = new File(tableDir, htable + ".html");
                FileUtils.copyURLToFile(srcUrl, destFile);
            }
            catch (Exception e) {
                logger.warn("HTable " + htable + "info fetch failed: ", e);
            }
        }
    }

    private void extractCommonInfo(File dest, KylinConfig config) throws IOException {
        logger.info("The hbase master info/conf are going to be extracted...");
        String hbaseNamespace = config.getHBaseStorageNameSpace();
        String tableNamePrefix = config.getHBaseTableNamePrefix();
        try {
            File masterDir = new File(dest, "master");
            FileUtils.forceMkdir(masterDir);
            URL srcMasterUrl = new URL(this.cachedHMasterUrl + "master-status");
            File masterDestFile = new File(masterDir, "master-status.html");
            FileUtils.copyURLToFile(srcMasterUrl, masterDestFile);
        }
        catch (Exception e) {
            logger.warn("HBase Master status fetch failed: ", e);
        }
        try {
            File confDir = new File(dest, "conf");
            FileUtils.forceMkdir(confDir);
            URL srcConfUrl = new URL(this.cachedHMasterUrl + "conf");
            File destConfFile = new File(confDir, "hbase-conf.xml");
            FileUtils.copyURLToFile(srcConfUrl, destConfFile);
        }
        catch (Exception e) {
            logger.warn("HBase conf fetch failed: ", e);
        }
        try {
            File jmxDir = new File(dest, "jmx");
            FileUtils.forceMkdir(jmxDir);
            URL srcJmxUrl = new URL(this.cachedHMasterUrl + "jmx");
            File jmxDestFile = new File(jmxDir, "jmx.html");
            FileUtils.copyURLToFile(srcJmxUrl, jmxDestFile);
        }
        catch (Exception e) {
            logger.warn("HBase JMX fetch failed: ", e);
        }
        try {
            File dumpDir = new File(dest, "dump");
            FileUtils.forceMkdir(dumpDir);
            URL srcDumpUrl = new URL(this.cachedHMasterUrl + "dump");
            File dumpDestFile = new File(dumpDir, "dump");
            FileUtils.copyURLToFile(srcDumpUrl, dumpDestFile);
        }
        catch (Exception e) {
            logger.warn("HBase Dump fetch failed: ", e);
        }
        try {
            File hdfsDir = new File(dest, "hdfs");
            FileUtils.forceMkdir(hdfsDir);
            CliCommandExecutor cliCommandExecutor = this.kylinConfig.getCliCommandExecutor();
            String command = String.format(Locale.ROOT, HDFS_CHECK_COMMAND, this.hbaseRootDir, hbaseNamespace, tableNamePrefix);
            logger.info("Execute command {}", (Object)command);
            String output = cliCommandExecutor.execute(command).getSecond();
            FileUtils.writeStringToFile(new File(hdfsDir, "hdfs-files.list"), output, Charset.defaultCharset());
        }
        catch (Exception e) {
            logger.warn("HBase hdfs status fetch failed: ", e);
        }
    }

    private IRealization getRealization(RealizationEntry realizationEntry) {
        return this.realizationRegistry.getRealization(realizationEntry.getType(), realizationEntry.getRealization());
    }

    private void retrieveResourcePath(IRealization realization) {
        logger.info("Deal with realization {} of type {}", (Object)realization.getName(), (Object)realization.getType());
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            for (CubeSegment segment : cube.getSegments()) {
                this.addHTable(segment.getStorageLocationIdentifier());
            }
        } else {
            logger.warn("Unknown realization type: {}", (Object)realization.getType());
        }
    }

    private void addHTable(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.htables.add(record);
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
    }
}

