/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobInstanceExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(JobInstanceExtractor.class);
    private static final int DEFAULT_PERIOD = 3;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_CUBE;
    private static final Option OPTION_PERIOD;
    KylinConfig config = KylinConfig.getInstanceFromEnv();
    ProjectManager projectManager;
    ExecutableManager executableManager = ExecutableManager.getInstance(this.config);

    public JobInstanceExtractor() {
        this.projectManager = ProjectManager.getInstance(this.config);
        this.packageType = "jobInstances";
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_CUBE);
        this.options.addOption(OPTION_PERIOD);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        String cube = optionsHelper.hasOption(OPTION_CUBE) ? optionsHelper.getOptionValue(OPTION_CUBE) : null;
        String project = optionsHelper.hasOption(OPTION_PROJECT) ? optionsHelper.getOptionValue(OPTION_PROJECT) : null;
        int period = optionsHelper.hasOption(OPTION_PERIOD) ? Integer.parseInt(optionsHelper.getOptionValue(OPTION_PERIOD)) : 3;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - (long)(period * 24 * 3600 * 1000);
        List<JobInstance> jobInstances = this.listJobInstances(project, cube, startTime, endTime);
        logger.info("There are {} jobInstances to extract.", (Object)jobInstances.size());
        ObjectMapper mapper = new ObjectMapper();
        for (JobInstance jobInstance : jobInstances) {
            mapper.writeValue(new File(exportDir, jobInstance.getUuid() + ".json"), (Object)jobInstance);
        }
    }

    private List<JobInstance> listJobInstances(String project, String cube, long startTime, long endTime) {
        ArrayList<JobInstance> result = Lists.newArrayList();
        List<AbstractExecutable> executables = this.executableManager.getAllExecutables(startTime, endTime);
        Map<String, Output> allOutputs = this.executableManager.getAllOutputs();
        for (AbstractExecutable executable : executables) {
            if (!(executable instanceof CubingJob)) continue;
            String cubeName = CubingExecutableUtil.getCubeName(executable.getParams());
            boolean shouldExtract = false;
            if (cube == null || cube.equalsIgnoreCase(cubeName)) {
                if (project == null) {
                    shouldExtract = true;
                } else {
                    ProjectInstance projectInstance = this.projectManager.getProject(project);
                    if (projectInstance != null && projectInstance.containsRealization(RealizationType.CUBE, cubeName)) {
                        shouldExtract = true;
                    }
                }
            }
            if (!shouldExtract) continue;
            result.add(this.parseToJobInstance((CubingJob)executable, allOutputs));
        }
        return result;
    }

    private JobInstance parseToJobInstance(CubingJob cubeJob, Map<String, Output> outputs) {
        CubeInstance cube = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(CubingExecutableUtil.getCubeName(cubeJob.getParams()));
        Output output = outputs.get(cubeJob.getId());
        JobInstance result = new JobInstance();
        result.setName(cubeJob.getName());
        result.setProjectName(cubeJob.getProjectName());
        if (cube != null) {
            result.setRelatedCube(cube.getName());
            result.setDisplayCubeName(cube.getDisplayName());
        } else {
            String cubeName = CubingExecutableUtil.getCubeName(cubeJob.getParams());
            result.setRelatedCube(cubeName);
            result.setDisplayCubeName(cubeName);
        }
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId(cubeJob.getParams()));
        result.setRelatedSegmentName(CubingExecutableUtil.getSegmentName(cubeJob.getParams()));
        result.setLastModified(output.getLastModified());
        result.setSubmitter(cubeJob.getSubmitter());
        result.setUuid(cubeJob.getId());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(this.parseToJobStatus(output.getState()));
        result.setMrWaiting(AbstractExecutable.getExtraInfoAsLong(output, "mapReduceWaitTime", 0L) / 1000L);
        result.setBuildInstance(AbstractExecutable.getBuildInstance(output));
        result.setExecStartTime(AbstractExecutable.getStartTime(output));
        result.setExecEndTime(AbstractExecutable.getEndTime(output));
        result.setExecInterruptTime(AbstractExecutable.getInterruptTime(output));
        result.setDuration(AbstractExecutable.getDuration(AbstractExecutable.getStartTime(output), AbstractExecutable.getEndTime(output), AbstractExecutable.getInterruptTime(output)) / 1000L);
        for (int i = 0; i < cubeJob.getTasks().size(); ++i) {
            AbstractExecutable task = cubeJob.getTasks().get(i);
            result.addStep(this.parseToJobStep(task, i, outputs.get(task.getId())));
        }
        return result;
    }

    private JobStatusEnum parseToJobStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStatusEnum.FINISHED;
            }
        }
        throw new RuntimeException("invalid state:" + (Object)((Object)state));
    }

    private JobInstance.JobStep parseToJobStep(AbstractExecutable task, int i, Output stepOutput) {
        Preconditions.checkNotNull(stepOutput);
        JobInstance.JobStep result = new JobInstance.JobStep();
        result.setId(task.getId());
        result.setName(task.getName());
        result.setSequenceID(i);
        result.setStatus(this.parseToJobStepStatus(stepOutput.getState()));
        for (Map.Entry<String, String> entry : stepOutput.getExtra().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result.putInfo(entry.getKey(), entry.getValue());
        }
        result.setExecStartTime(AbstractExecutable.getStartTime(stepOutput));
        result.setExecEndTime(AbstractExecutable.getEndTime(stepOutput));
        if (task instanceof ShellExecutable) {
            result.setExecCmd(((ShellExecutable)task).getCmd());
        }
        if (task instanceof MapReduceExecutable) {
            result.setExecCmd(((MapReduceExecutable)task).getMapReduceParams());
            result.setExecWaitTime(AbstractExecutable.getExtraInfoAsLong(stepOutput, "mapReduceWaitTime", 0L) / 1000L);
        }
        if (task instanceof HadoopShellExecutable) {
            result.setExecCmd(((HadoopShellExecutable)task).getJobParams());
        }
        return result;
    }

    private JobStepStatusEnum parseToJobStepStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStepStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStepStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStepStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStepStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStepStatusEnum.FINISHED;
            }
        }
        throw new RuntimeException("invalid state:" + (Object)((Object)state));
    }

    static {
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify jobs in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify jobs related to which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"period");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify how many days of kylin jobs to extract. Default 3.");
        OPTION_PERIOD = OptionBuilder.create((String)"period");
    }
}

