/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.shaded.com.tdunning.math.stats;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.tool.shaded.com.tdunning.math.stats.AbstractTDigest;
import org.apache.kylin.tool.shaded.com.tdunning.math.stats.Centroid;
import org.apache.kylin.tool.shaded.com.tdunning.math.stats.Sort;
import org.apache.kylin.tool.shaded.com.tdunning.math.stats.TDigest;

public class MergingDigest
extends AbstractTDigest {
    private final double compression;
    private int lastUsedCell;
    private double totalWeight = 0.0;
    private double[] weight;
    private double[] mean;
    private double min;
    private double max;
    private List<List<Double>> data = null;
    private double[] mergeWeight;
    private double[] mergeMean;
    private List<List<Double>> mergeData = null;
    private double unmergedWeight = 0.0;
    private int tempUsed = 0;
    private double[] tempWeight;
    private double[] tempMean;
    private List<List<Double>> tempData = null;
    private int[] order;

    public MergingDigest(double compression) {
        this(compression, MergingDigest.estimateBufferSize(compression));
    }

    private static int estimateBufferSize(double compression) {
        if (compression < 20.0) {
            compression = 20.0;
        }
        if (compression > 1000.0) {
            compression = 1000.0;
        }
        return (int)(7.5 + 0.37 * compression - 2.0E-4 * compression * compression);
    }

    public MergingDigest(double compression, int bufferSize) {
        this(compression, bufferSize, (int)(Math.PI * compression + 0.5));
    }

    public MergingDigest(double compression, int bufferSize, int size) {
        this.compression = compression;
        this.weight = new double[size];
        this.mean = new double[size];
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.mergeWeight = new double[size];
        this.mergeMean = new double[size];
        this.tempWeight = new double[bufferSize];
        this.tempMean = new double[bufferSize];
        this.order = new int[bufferSize];
        this.lastUsedCell = 0;
    }

    @Override
    public TDigest recordAllData() {
        super.recordAllData();
        this.data = new ArrayList<List<Double>>();
        this.mergeData = new ArrayList<List<Double>>();
        return this;
    }

    @Override
    void add(double x, int w, Centroid base) {
        this.add(x, w, base.data());
    }

    @Override
    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    public void add(double x, int w, List<Double> history) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("Cannot add NaN to t-digest");
        }
        if (this.tempUsed >= this.tempWeight.length) {
            this.mergeNewValues();
        }
        int where = this.tempUsed++;
        this.tempWeight[where] = w;
        this.tempMean[where] = x;
        this.unmergedWeight += (double)w;
        if (this.data != null) {
            if (this.tempData == null) {
                this.tempData = new ArrayList<List<Double>>();
            }
            while (this.tempData.size() <= where) {
                this.tempData.add(new ArrayList());
            }
            if (history == null) {
                history = Collections.singletonList(x);
            }
            this.tempData.get(where).addAll(history);
        }
    }

    private void mergeNewValues() {
        if (this.unmergedWeight > 0.0) {
            int ix;
            Sort.sort(this.order, this.tempMean, this.tempUsed);
            double wSoFar = 0.0;
            double k1 = 0.0;
            int i = 0;
            int j = 0;
            int n = 0;
            if (this.totalWeight > 0.0) {
                n = this.weight[this.lastUsedCell] > 0.0 ? this.lastUsedCell + 1 : this.lastUsedCell;
            }
            this.lastUsedCell = 0;
            this.totalWeight += this.unmergedWeight;
            this.unmergedWeight = 0.0;
            while (i < this.tempUsed && j < n) {
                ix = this.order[i];
                if (this.tempMean[ix] <= this.mean[j]) {
                    k1 = this.mergeCentroid(wSoFar += this.tempWeight[ix], k1, this.tempWeight[ix], this.tempMean[ix], this.tempData != null ? this.tempData.get(ix) : null);
                    ++i;
                    continue;
                }
                k1 = this.mergeCentroid(wSoFar += this.weight[j], k1, this.weight[j], this.mean[j], this.data != null ? this.data.get(j) : null);
                ++j;
            }
            while (i < this.tempUsed) {
                ix = this.order[i];
                k1 = this.mergeCentroid(wSoFar += this.tempWeight[ix], k1, this.tempWeight[ix], this.tempMean[ix], this.tempData != null ? this.tempData.get(ix) : null);
                ++i;
            }
            while (j < n) {
                k1 = this.mergeCentroid(wSoFar += this.weight[j], k1, this.weight[j], this.mean[j], this.data != null ? this.data.get(j) : null);
                ++j;
            }
            this.tempUsed = 0;
            double[] z = this.weight;
            this.weight = this.mergeWeight;
            this.mergeWeight = z;
            Arrays.fill(this.mergeWeight, 0.0);
            z = this.mean;
            this.mean = this.mergeMean;
            this.mergeMean = z;
            if (this.totalWeight > 0.0) {
                this.min = Math.min(this.min, this.mean[0]);
                this.max = this.weight[this.lastUsedCell] > 0.0 ? Math.max(this.max, this.mean[this.lastUsedCell]) : Math.max(this.max, this.mean[this.lastUsedCell - 1]);
            }
            if (this.data != null) {
                this.data = this.mergeData;
                this.mergeData = new ArrayList<List<Double>>();
                this.tempData = new ArrayList<List<Double>>();
            }
        }
    }

    private double mergeCentroid(double wSoFar, double k1, double w, double m, List<Double> newData) {
        double k2 = this.integratedLocation(wSoFar / this.totalWeight);
        if (k2 - k1 <= 1.0 || this.mergeWeight[this.lastUsedCell] == 0.0) {
            int n = this.lastUsedCell;
            this.mergeWeight[n] = this.mergeWeight[n] + w;
            this.mergeMean[this.lastUsedCell] = this.mergeMean[this.lastUsedCell] + (m - this.mergeMean[this.lastUsedCell]) * w / this.mergeWeight[this.lastUsedCell];
        } else {
            ++this.lastUsedCell;
            this.mergeMean[this.lastUsedCell] = m;
            this.mergeWeight[this.lastUsedCell] = w;
            k1 = this.integratedLocation((wSoFar - w) / this.totalWeight);
        }
        if (this.mergeData != null) {
            while (this.mergeData.size() <= this.lastUsedCell) {
                this.mergeData.add(new ArrayList());
            }
            this.mergeData.get(this.lastUsedCell).addAll(newData);
        }
        return k1;
    }

    int checkWeights() {
        return this.checkWeights(this.weight, this.totalWeight, this.lastUsedCell);
    }

    private int checkWeights(double[] w, double total, int last) {
        int badCount = 0;
        int n = last;
        if (w[n] > 0.0) {
            ++n;
        }
        double k1 = 0.0;
        double q = 0.0;
        for (int i = 0; i < n; ++i) {
            double dq = w[i] / total;
            double k2 = this.integratedLocation(q + dq);
            if (k2 - k1 > 1.0 && w[i] != 1.0) {
                System.out.printf("Oversize centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f\n", i, k1, k2, k2 - k1, w[i], q);
                ++badCount;
            }
            if (k2 - k1 > 1.5 && w[i] != 1.0) {
                throw new IllegalStateException(String.format("Egregiously oversized centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f\n", i, k1, k2, k2 - k1, w[i], q));
            }
            q += dq;
            k1 = k2;
        }
        return badCount;
    }

    private double integratedLocation(double q) {
        return this.compression * (Math.asin(2.0 * q - 1.0) + 1.5707963267948966) / Math.PI;
    }

    @Override
    public void compress() {
        this.mergeNewValues();
    }

    @Override
    public long size() {
        return (long)(this.totalWeight + this.unmergedWeight);
    }

    @Override
    public double cdf(double x) {
        double aCount;
        double left;
        this.mergeNewValues();
        if (this.lastUsedCell == 0) {
            if (this.weight[this.lastUsedCell] == 0.0) {
                return Double.NaN;
            }
            if (x < this.min) {
                return 0.0;
            }
            if (x > this.max) {
                return 1.0;
            }
            if (this.max - this.min < Double.MIN_NORMAL) {
                return 0.5;
            }
            return (x - this.min) / (this.max - this.min);
        }
        int n = this.lastUsedCell;
        if (this.weight[n] > 0.0) {
            ++n;
        }
        if (x < this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        double r = 0.0;
        double a = this.min;
        double b = this.min;
        double bCount = 0.0;
        double right = 0.0;
        for (int it = 0; it < n; ++it) {
            left = b - (a + right);
            a = b;
            aCount = bCount;
            right = ((b = this.mean[it]) - a) * aCount / (aCount + (bCount = this.weight[it]));
            if (x < a + right) {
                double value = (r + aCount * MergingDigest.interpolate(x, a - left, a + right)) / this.totalWeight;
                return value > 0.0 ? value : 0.0;
            }
            r += aCount;
        }
        left = b - (a + right);
        a = b;
        aCount = bCount;
        right = this.max - a;
        if (x < a + right) {
            return (r + aCount * MergingDigest.interpolate(x, a - left, a + right)) / this.totalWeight;
        }
        return 1.0;
    }

    @Override
    public double quantile(double q) {
        double left;
        double aCount;
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        this.mergeNewValues();
        if (this.lastUsedCell == 0 && this.weight[this.lastUsedCell] == 0.0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 0) {
            return this.mean[0];
        }
        int n = this.lastUsedCell;
        if (this.weight[n] > 0.0) {
            ++n;
        }
        double index = q * this.totalWeight;
        double right = this.min;
        double b = this.mean[0];
        double bCount = this.weight[0];
        double weightSoFar = 0.0;
        for (int it = 1; it < n; ++it) {
            double a = b;
            aCount = bCount;
            left = right;
            b = this.mean[it];
            bCount = this.weight[it];
            right = (bCount * a + aCount * b) / (aCount + bCount);
            if (index < weightSoFar + aCount) {
                double p = (index - weightSoFar) / aCount;
                return left * (1.0 - p) + right * p;
            }
            weightSoFar += aCount;
        }
        left = right;
        aCount = bCount;
        right = this.max;
        if (index < weightSoFar + aCount) {
            double p = (index - weightSoFar) / aCount;
            return left * (1.0 - p) + right * p;
        }
        return this.max;
    }

    @Override
    public Collection<Centroid> centroids() {
        this.compress();
        ArrayList<Centroid> r = new ArrayList<Centroid>();
        for (int i = 0; i <= this.lastUsedCell; ++i) {
            r.add(new Centroid(this.mean[i], (int)this.weight[i], this.data != null ? this.data.get(i) : null));
        }
        return r;
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        this.compress();
        return (this.lastUsedCell + 1) * 16 + 40;
    }

    @Override
    public int smallByteSize() {
        this.compress();
        return this.lastUsedCell * 8 + 38;
    }

    void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.VERBOSE_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putFloat((float)this.compression);
        buf.putFloat((float)this.compression);
        buf.putInt(this.mean.length);
        buf.putInt(this.tempMean.length);
        buf.putInt(this.lastUsedCell);
        for (int i = 0; i <= this.lastUsedCell; ++i) {
            buf.putDouble(this.weight[i]);
            buf.putDouble(this.mean[i]);
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.SMALL_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putFloat((float)this.compression);
        buf.putShort((short)this.mean.length);
        buf.putShort((short)this.tempMean.length);
        buf.putShort((short)this.lastUsedCell);
        for (int i = 0; i <= this.lastUsedCell; ++i) {
            buf.putFloat((float)this.weight[i]);
            buf.putFloat((float)this.mean[i]);
        }
    }

    public static MergingDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == Encoding.VERBOSE_ENCODING.code) {
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getFloat();
            int n = buf.getInt();
            int bufferSize = buf.getInt();
            MergingDigest r = new MergingDigest(compression, bufferSize, n);
            r.min = min;
            r.max = max;
            r.lastUsedCell = buf.getInt();
            for (int i = 0; i <= r.lastUsedCell; ++i) {
                r.weight[i] = buf.getDouble();
                r.mean[i] = buf.getDouble();
                r.totalWeight += r.weight[i];
            }
            return r;
        }
        if (encoding == Encoding.SMALL_ENCODING.code) {
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getFloat();
            short n = buf.getShort();
            short bufferSize = buf.getShort();
            MergingDigest r = new MergingDigest(compression, bufferSize, n);
            r.min = min;
            r.max = max;
            r.lastUsedCell = buf.getShort();
            for (int i = 0; i <= r.lastUsedCell; ++i) {
                r.weight[i] = buf.getFloat();
                r.mean[i] = buf.getFloat();
                r.totalWeight += r.weight[i];
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }

    public static enum Encoding {
        VERBOSE_ENCODING(1),
        SMALL_ENCODING(2);

        private final int code;

        private Encoding(int code) {
            this.code = code;
        }
    }
}

