/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.io.Serializable;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeyColumnIO
implements Serializable {
    private final IDimensionEncodingMap dimEncMap;

    public RowKeyColumnIO(IDimensionEncodingMap dimEncMap) {
        this.dimEncMap = dimEncMap;
    }

    public int getColumnLength(TblColRef col) {
        return this.dimEncMap.get(col).getLengthOfEncoding();
    }

    public Dictionary<String> getDictionary(TblColRef col) {
        return this.dimEncMap.getDictionary(col);
    }

    public void writeColumn(TblColRef col, String value, int roundingFlag, byte defaultValue, byte[] output, int outputOffset) {
        DimensionEncoding dimEnc = this.dimEncMap.get(col);
        if (dimEnc instanceof DictionaryDimEnc) {
            dimEnc = ((DictionaryDimEnc)dimEnc).copy(roundingFlag, defaultValue);
        }
        dimEnc.encode(value, output, outputOffset);
    }

    public String readColumnString(TblColRef col, byte[] bytes, int offset, int length) {
        DimensionEncoding dimEnc = this.dimEncMap.get(col);
        return dimEnc.decode(bytes, offset, length);
    }
}

